/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.network;

import dev.architectury.injectables.annotations.ExpectPlatform;
import io.github.mortuusars.envelope.PlatformHelper;
import io.github.mortuusars.envelope.network.neoforge.PacketsImpl;
import io.github.mortuusars.envelope.network.packet.Packet;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Packets {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void sendToServer(Packet packet) {
        PacketsImpl.sendToServer(packet);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void sendToClient(Packet packet, ServerPlayer player) {
        void var1_1;
        PacketsImpl.sendToClient(packet, (ServerPlayer)var1_1);
    }

    public static void sendToAllClients(Packet packet) {
        MinecraftServer server = Objects.requireNonNull(PlatformHelper.getCurrentServer(), "Cannot send clientbound payloads on the client");
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            Packets.sendToClient(packet, player);
        }
    }

    public static void sendToAllClients(Function<RegistryAccess, Packet> packet) {
        MinecraftServer server = Objects.requireNonNull(PlatformHelper.getCurrentServer(), "Cannot send clientbound payloads on the client");
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            Packets.sendToClient(packet.apply((RegistryAccess)server.registryAccess()), player);
        }
    }

    public static void sendToOtherClients(@NotNull ServerPlayer except, Packet packet) {
        except.server.getPlayerList().getPlayers().forEach(player -> {
            if (!player.equals((Object)except)) {
                Packets.sendToClient(packet, player);
            }
        });
    }

    public static void sendToClients(Packet packet, Predicate<ServerPlayer> filter) {
        MinecraftServer server = Objects.requireNonNull(PlatformHelper.getCurrentServer(), "Cannot send clientbound payloads on the client");
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            if (!filter.test(player)) continue;
            Packets.sendToClient(packet, player);
        }
    }

    public static void sendToPlayersNear(Packet packet, ServerLevel level, @Nullable ServerPlayer excluded, Entity entity, double radius) {
        Packets.sendToPlayersNear(packet, level, excluded, entity.getX(), entity.getY(), entity.getZ(), radius);
    }

    public static void sendToPlayersNear(Packet packet, @NotNull ServerLevel level, @Nullable ServerPlayer excludedPlayer, double x, double y, double z, double radius) {
        Packets.sendToClients(packet, player -> {
            if (player != excludedPlayer && player.level().dimension() == level.dimension()) {
                double d2;
                double d1;
                double d0 = x - player.getX();
                return d0 * d0 + (d1 = y - player.getY()) * d1 + (d2 = z - player.getZ()) * d2 < radius * radius;
            }
            return false;
        });
    }
}

