/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.network.packet.clientbound;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.network.packet.Packet;
import io.github.mortuusars.envelope.world.inventory.MailboxMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class MailboxHasNewMailS2CP
implements Packet {
    public static final MailboxHasNewMailS2CP INSTANCE = new MailboxHasNewMailS2CP();
    public static final ResourceLocation ID = Envelope.resource("mailbox_has_new_mail");
    public static final CustomPacketPayload.Type<MailboxHasNewMailS2CP> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, MailboxHasNewMailS2CP> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);

    private MailboxHasNewMailS2CP() {
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public boolean handle(PacketFlow flow, Player player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (!(abstractContainerMenu instanceof MailboxMenu)) {
            Envelope.LOGGER.error("Cannot handle '{}' packet: Player '{}' does not have MailboxMenu open.", (Object)ID, (Object)player);
            return false;
        }
        MailboxMenu menu = (MailboxMenu)abstractContainerMenu;
        menu.setHasNewMail(true);
        player.level().playSound(player, (Entity)player, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.MASTER, 0.75f, 1.0f);
        return true;
    }
}

