/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.network.packet.serverbound;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.network.packet.Packet;
import io.github.mortuusars.envelope.world.item.AddressTagItem;
import io.github.mortuusars.envelope.world.mail.address.Address;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public record AddressTagApplyC2SP(int slot, Optional<Address> address) implements Packet
{
    public static final ResourceLocation ID = Envelope.resource("address_tag_apply");
    public static final CustomPacketPayload.Type<AddressTagApplyC2SP> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, AddressTagApplyC2SP> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, AddressTagApplyC2SP::slot, (StreamCodec)ByteBufCodecs.optional(Address.STREAM_CODEC), AddressTagApplyC2SP::address, AddressTagApplyC2SP::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public boolean handle(PacketFlow direction, Player player) {
        if (this.slot < 0 || this.slot > player.getInventory().items.size()) {
            Envelope.LOGGER.error("Cannot handle {} packet: slot {} is not in valid range (0 - {}).", new Object[]{ID, this.slot, player.getInventory().items.size()});
            return false;
        }
        ItemStack tag = player.getInventory().getItem(this.slot);
        if (tag.getItem() instanceof AddressTagItem) {
            this.address.ifPresentOrElse(value -> tag.set(Envelope.DataComponents.ADDRESS, value), () -> tag.remove(Envelope.DataComponents.ADDRESS));
            return true;
        }
        return false;
    }
}

