/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.network.packet.serverbound;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.network.packet.Packet;
import io.github.mortuusars.envelope.world.item.LetterAndQuillItem;
import io.github.mortuusars.envelope.world.item.component.LetterAndQuillContent;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public record LetterEditC2SP(int slot, String text, boolean fold) implements Packet
{
    public static final ResourceLocation ID = Envelope.resource("letter_edit");
    public static final CustomPacketPayload.Type<LetterEditC2SP> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, LetterEditC2SP> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, LetterEditC2SP::slot, (StreamCodec)ByteBufCodecs.stringUtf8((int)4096), LetterEditC2SP::text, (StreamCodec)ByteBufCodecs.BOOL, LetterEditC2SP::fold, LetterEditC2SP::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public boolean handle(PacketFlow direction, Player player) {
        if (this.slot < 0 || this.slot > player.getInventory().items.size()) {
            Envelope.LOGGER.error("Cannot handle {} packet: slot {} is not in valid range (0 - {}).", new Object[]{ID, this.slot, player.getInventory().items.size()});
            return false;
        }
        ItemStack letterAndQuill = player.getInventory().getItem(this.slot);
        if (!(letterAndQuill.getItem() instanceof LetterAndQuillItem)) {
            Envelope.LOGGER.error("Cannot handle {} packet: item in slot {} is not a LetterAndQuillItem.", (Object)ID, (Object)this.slot);
            return false;
        }
        LetterAndQuillContent content = new LetterAndQuillContent(this.text);
        if (this.fold) {
            ItemStack letter = new ItemStack((ItemLike)Envelope.Items.LETTER.get());
            if (!content.isEmpty()) {
                letter.set(Envelope.DataComponents.LETTER_CONTENT, (Object)content.toWritten());
            }
            player.level().playSound(null, (Entity)player, Envelope.SoundEvents.PAPER_CRACKLE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            player.getInventory().setItem(this.slot, letter);
        } else if (!content.isEmpty()) {
            letterAndQuill.set(Envelope.DataComponents.LETTER_AND_QUILL_CONTENT, (Object)content);
        } else {
            letterAndQuill.remove(Envelope.DataComponents.LETTER_AND_QUILL_CONTENT);
        }
        return true;
    }
}

