/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.network.packet.serverbound;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.network.packet.Packet;
import io.github.mortuusars.envelope.world.block.mailbox.MailboxBlock;
import io.github.mortuusars.envelope.world.item.AddressTagItem;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public record MailboxAddressTagApplyC2SP(InteractionHand hand, String addressId, BlockPos pos) implements Packet
{
    public static final ResourceLocation ID = Envelope.resource("mailbox_address_tag_apply");
    public static final CustomPacketPayload.Type<MailboxAddressTagApplyC2SP> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, MailboxAddressTagApplyC2SP> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT.map(i -> InteractionHand.values()[i], Enum::ordinal), MailboxAddressTagApplyC2SP::hand, (StreamCodec)ByteBufCodecs.STRING_UTF8, MailboxAddressTagApplyC2SP::addressId, (StreamCodec)BlockPos.STREAM_CODEC, MailboxAddressTagApplyC2SP::pos, MailboxAddressTagApplyC2SP::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public boolean handle(PacketFlow direction, Player player) {
        ItemStack tag = player.getItemInHand(this.hand);
        if (!(tag.getItem() instanceof AddressTagItem)) {
            Envelope.LOGGER.error("Cannot handle {} packet: item in hand is not an AddressTagItem, but {}.", (Object)ID, (Object)tag);
            return false;
        }
        BlockState state = player.level().getBlockState(this.pos);
        Block block = state.getBlock();
        if (!(block instanceof MailboxBlock)) {
            Envelope.LOGGER.error("Cannot handle {} packet: block at pos [{}] is not a MailboxBlock", (Object)ID, (Object)this.pos);
            return false;
        }
        MailboxBlock block2 = (MailboxBlock)block;
        block2.changeAddress(player, this.pos, this.hand, this.addressId);
        return true;
    }
}

