/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.network.packet.serverbound;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.network.packet.Packet;
import io.github.mortuusars.envelope.util.EnvelopeStreamCodecs;
import io.github.mortuusars.envelope.world.block.mailbox.MailboxBlock;
import io.github.mortuusars.envelope.world.item.MailboxBlockItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public record MailboxPlaceC2SP(InteractionHand hand, String address, BlockHitResult hitResult) implements Packet
{
    public static final ResourceLocation ID = Envelope.resource("mailbox_place");
    public static final CustomPacketPayload.Type<MailboxPlaceC2SP> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, MailboxPlaceC2SP> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT.map(i -> InteractionHand.values()[i], Enum::ordinal), MailboxPlaceC2SP::hand, (StreamCodec)ByteBufCodecs.STRING_UTF8, MailboxPlaceC2SP::address, EnvelopeStreamCodecs.BLOCK_HIT_RESULT, MailboxPlaceC2SP::hitResult, MailboxPlaceC2SP::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public boolean handle(PacketFlow direction, Player player) {
        Item item;
        ItemStack mailbox = player.getItemInHand(this.hand);
        if (mailbox.isEmpty() || !((item = mailbox.getItem()) instanceof MailboxBlockItem)) {
            Envelope.LOGGER.error("Cannot handle {} packet: {} is not a valid mailbox item.", (Object)ID, (Object)mailbox);
            return false;
        }
        MailboxBlockItem blockItem = (MailboxBlockItem)item;
        BlockPlaceContext context = new BlockPlaceContext(player, this.hand, mailbox, this.hitResult);
        MailboxBlock.placeBlockWithAddress(player, this.hand, context, this.address);
        return true;
    }
}

