/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;

public interface EnvelopeCodecs {
    public static final Codec<Integer> HEX_COLOR = Codec.STRING.comapFlatMap(hex -> {
        try {
            int color = (int)Long.parseLong(hex.replace("#", ""), 16);
            return DataResult.success((Object)color);
        }
        catch (NumberFormatException e) {
            return DataResult.error(() -> "Invalid color value: " + hex);
        }
    }, color -> "#" + String.format("%08X", color));
}

