/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.util;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemAndStack<T extends Item>
implements DataComponentHolder {
    private final T item;
    private final ItemStack stack;

    public ItemAndStack(ItemStack stack) {
        this.stack = stack;
        this.item = stack.getItem();
    }

    public T getItem() {
        return this.item;
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    public ItemAndStack<T> apply(BiConsumer<T, ItemStack> function) {
        function.accept(this.item, this.stack);
        return this;
    }

    public <R> R map(BiFunction<T, ItemStack, R> mappingFunction) {
        return mappingFunction.apply(this.item, this.stack);
    }

    @NotNull
    public DataComponentMap getComponents() {
        return this.stack.getComponents();
    }

    @Nullable
    public <C> C set(DataComponentType<? super C> component, @Nullable C value) {
        return (C)this.stack.set(component, value);
    }

    @Nullable
    public <C, U> C update(DataComponentType<C> component, C defaultValue, U updateValue, BiFunction<C, U, C> updater) {
        return this.set(component, updater.apply(this.stack.getOrDefault(component, defaultValue), updateValue));
    }

    @Nullable
    public <C> C update(DataComponentType<C> component, C defaultValue, UnaryOperator<C> updater) {
        Object object = this.getOrDefault(component, defaultValue);
        return this.set(component, updater.apply(object));
    }

    @Nullable
    public <C> C remove(DataComponentType<? extends C> component) {
        return (C)this.stack.remove(component);
    }

    public String toString() {
        return "ItemAndStack{" + this.stack.toString() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemAndStack that = (ItemAndStack)o;
        return Objects.equals(this.item, that.item) && Objects.equals(this.stack, that.stack);
    }

    public int hashCode() {
        return Objects.hash(this.item, this.stack);
    }
}

