/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.serialization.Codec;
import io.github.mortuusars.envelope.util.EnvelopeCodecs;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public record TintColor(float r, float g, float b, float a) {
    public static final Codec<TintColor> CODEC = EnvelopeCodecs.HEX_COLOR.xmap(TintColor::of, TintColor::tint);
    public static final StreamCodec<ByteBuf, TintColor> STREAM_CODEC = ByteBufCodecs.INT.map(TintColor::of, TintColor::tint);

    public static TintColor of(int argb) {
        float a = (float)(FastColor.ARGB32.alpha((int)argb) - 127) / 127.0f + 1.0f;
        float r = (float)(FastColor.ARGB32.red((int)argb) - 127) / 127.0f + 1.0f;
        float g = (float)(FastColor.ARGB32.green((int)argb) - 127) / 127.0f + 1.0f;
        float b = (float)(FastColor.ARGB32.blue((int)argb) - 127) / 127.0f + 1.0f;
        return new TintColor(r, g, b, a);
    }

    public void setShaderColor() {
        RenderSystem.setShaderColor((float)this.r, (float)this.g, (float)this.b, (float)this.a);
    }

    public int tint(int argb) {
        int a = (int)Mth.clamp((float)((float)FastColor.ARGB32.alpha((int)argb) * this.a), (float)0.0f, (float)255.0f);
        int r = (int)Mth.clamp((float)((float)FastColor.ARGB32.red((int)argb) * this.r), (float)0.0f, (float)255.0f);
        int g = (int)Mth.clamp((float)((float)FastColor.ARGB32.green((int)argb) * this.g), (float)0.0f, (float)255.0f);
        int b = (int)Mth.clamp((float)((float)FastColor.ARGB32.blue((int)argb) * this.b), (float)0.0f, (float)255.0f);
        return FastColor.ARGB32.color((int)a, (int)r, (int)g, (int)b);
    }

    public int tint() {
        return this.tint(-8421505);
    }
}

