/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.util.bugger;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.envelope.network.Packets;
import io.github.mortuusars.envelope.util.bugger.Bugger;
import io.github.mortuusars.envelope.util.bugger.data.Data;
import io.github.mortuusars.envelope.util.bugger.network.BuggerDataS2CP;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BuggerData {
    public static final Map<ResourceLocation, Data<?>> DEFINITIONS = new HashMap();
    public static final Map<ResourceLocation, Object> DATA = new HashMap<ResourceLocation, Object>();
    private static final Logger LOGGER = LogUtils.getLogger();

    public static <T> Optional<T> get(ResourceLocation id) {
        if (!Bugger.isEnabled()) {
            return Optional.empty();
        }
        try {
            Object value = DATA.get(id);
            return Optional.ofNullable(value);
        }
        catch (ClassCastException e) {
            LOGGER.error("Stored bugger data '{}' has incorrect type: ", (Object)id, (Object)e);
            return Optional.empty();
        }
    }

    public static void send(ResourceLocation id, Function<RegistryAccess, @Nullable Tag> dataSupplier) {
        Packets.sendToAllClients(registryAccess -> {
            CompoundTag tag = new CompoundTag();
            @Nullable Tag data = (Tag)dataSupplier.apply((RegistryAccess)registryAccess);
            if (data != null) {
                tag.put("data", data);
            }
            return new BuggerDataS2CP(id, tag);
        });
    }

    public static void receive(ResourceLocation id, CompoundTag tag, RegistryAccess registryAccess) {
        Object newValue;
        if (!Bugger.isEnabled()) {
            return;
        }
        Data<?> definition = Objects.requireNonNull(DEFINITIONS.get(id), "Definition '" + String.valueOf(id) + "' was not registered.");
        Object v0 = newValue = tag.contains("data") ? definition.decode(tag.get("data"), registryAccess) : null;
        if (newValue == null) {
            DATA.put(id, null);
        } else {
            BuggerData.receiveInternal(definition, id, newValue);
        }
    }

    private static <T> void receiveInternal(Data<T> definition, ResourceLocation id, @NotNull Object newValueObj) {
        DATA.compute(id, (dataId, existingValueObj) -> {
            if (existingValueObj == null) {
                return newValueObj;
            }
            Object existingValue = existingValueObj;
            Object newValue = newValueObj;
            Object appliedValue = definition.apply(existingValue, newValue);
            definition.handle(appliedValue);
            return appliedValue;
        });
    }
}

