/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.util.bugger;

import com.google.common.base.Strings;
import io.github.mortuusars.envelope.client.util.Minecrft;
import io.github.mortuusars.envelope.util.bugger.Bugger;
import io.github.mortuusars.envelope.util.bugger.page.BuggerPage;
import io.github.mortuusars.envelope.util.bugger.page.DataPage;
import io.github.mortuusars.envelope.util.bugger.page.LogPage;
import io.github.mortuusars.envelope.util.bugger.page.VanillaDebugPage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class BuggerDebugScreen {
    private static final List<BuggerPage> pages = new ArrayList<BuggerPage>();
    private static int currentPageIndex;
    private static BuggerPage currentPage;
    private static int zoom;
    private static int scroll;

    public static boolean active() {
        return Bugger.isEnabled() && Minecrft.get().gui.getDebugOverlay().showDebugScreen();
    }

    public static boolean isOnVanillaDebugPage() {
        return currentPage instanceof VanillaDebugPage;
    }

    public static void addPage(BuggerPage page) {
        pages.add(page);
    }

    public static void prevPage() {
        BuggerDebugScreen.setPage(currentPageIndex - 1);
    }

    public static void nextPage() {
        BuggerDebugScreen.setPage(currentPageIndex + 1);
    }

    public static void setPage(int index) {
        int newPage = Mth.clamp((int)index, (int)0, (int)(pages.size() - 1));
        if (currentPageIndex != newPage) {
            currentPage.deactivated();
            currentPageIndex = newPage;
            currentPage = pages.get(currentPageIndex);
            currentPage.activated();
            scroll = 0;
        }
    }

    public static Optional<BuggerPage> getPreviousPage() {
        int page = currentPageIndex - 1;
        return page >= 0 && page < pages.size() ? Optional.of(pages.get(page)) : Optional.empty();
    }

    public static Optional<BuggerPage> getNextPage() {
        int page = currentPageIndex + 1;
        return page >= 0 && page < pages.size() ? Optional.of(pages.get(page)) : Optional.empty();
    }

    public static boolean render(GuiGraphics guiGraphics) {
        if (!BuggerDebugScreen.active()) {
            return false;
        }
        Minecraft.getInstance().getProfiler().push("bugger");
        if (zoom == 0) {
            zoom = (int)Minecrft.get().getWindow().getGuiScale();
        }
        guiGraphics.drawManaged(() -> {
            BuggerDebugScreen.drawPageTabs(guiGraphics);
            float scale = (float)((double)zoom / Minecrft.get().getWindow().getGuiScale());
            if (!BuggerDebugScreen.isOnVanillaDebugPage()) {
                List<String> leftLines = currentPage.getLeftLines();
                List<String> rightLines = currentPage.getRightLines();
                int correctedScroll = scroll;
                int maxScroll = Math.max(leftLines.size() - 8, 0);
                int effectiveScroll = Mth.clamp((int)scroll, (int)0, (int)maxScroll);
                if (!leftLines.isEmpty()) {
                    guiGraphics.pose().pushPose();
                    guiGraphics.pose().scale(scale, scale, scale);
                    correctedScroll = Math.min(scroll, effectiveScroll);
                    leftLines = leftLines.stream().skip(effectiveScroll).toList();
                    BuggerDebugScreen.drawLines(guiGraphics, leftLines, true);
                    guiGraphics.pose().popPose();
                }
                if (!rightLines.isEmpty()) {
                    guiGraphics.pose().pushPose();
                    guiGraphics.pose().translate((float)Minecrft.get().getWindow().getGuiScaledWidth(), 0.0f, 0.0f);
                    guiGraphics.pose().scale(scale, scale, scale);
                    guiGraphics.pose().translate((float)(-Minecrft.get().getWindow().getGuiScaledWidth()), 0.0f, 0.0f);
                    maxScroll = Math.max(rightLines.size() - 8, 0);
                    effectiveScroll = Mth.clamp((int)scroll, (int)0, (int)maxScroll);
                    correctedScroll = Math.max(correctedScroll, effectiveScroll);
                    rightLines = rightLines.stream().skip(effectiveScroll).toList();
                    BuggerDebugScreen.drawLines(guiGraphics, rightLines, false);
                    guiGraphics.pose().popPose();
                }
                scroll = correctedScroll;
            }
            currentPage.render(guiGraphics, Minecrft.get().getTimer().getGameTimeDeltaPartialTick(true), scale);
        });
        Minecraft.getInstance().getProfiler().pop();
        return !BuggerDebugScreen.isOnVanillaDebugPage();
    }

    private static void drawPageTabs(GuiGraphics guiGraphics) {
        int titleBgColor = -1873784752;
        int sideBgColor = 0x50505050;
        int titleFontColor = -1;
        int sideFontColor = -1118482;
        String prevTitle = BuggerDebugScreen.getPreviousPage().map(buggerPage -> "\u2039 " + buggerPage.getTitle()).orElse("");
        String title = currentPage.getTitle();
        String nextTitle = BuggerDebugScreen.getNextPage().map(buggerPage -> buggerPage.getTitle() + " \u203a").orElse("");
        int titleWidth = Minecraft.getInstance().font.width(title);
        int titleX = guiGraphics.guiWidth() / 2 - titleWidth / 2;
        guiGraphics.fill(titleX - 4, 1, titleX + titleWidth + 4, 10, titleBgColor);
        guiGraphics.drawString(Minecraft.getInstance().font, title, titleX, 2, titleFontColor, false);
        if (!prevTitle.isEmpty()) {
            int prevWidth = Minecraft.getInstance().font.width(prevTitle);
            int prevX = titleX - prevWidth - 7;
            guiGraphics.fill(prevX - 1, 1, prevX + prevWidth + 1, 10, sideBgColor);
            guiGraphics.drawString(Minecraft.getInstance().font, prevTitle, prevX, 2, sideFontColor, false);
        }
        if (!nextTitle.isEmpty()) {
            int nextWidth = Minecraft.getInstance().font.width(nextTitle);
            int nextX = titleX + titleWidth + 7;
            guiGraphics.fill(nextX - 1, 1, nextX + nextWidth + 1, 10, sideBgColor);
            guiGraphics.drawString(Minecraft.getInstance().font, nextTitle, nextX, 2, sideFontColor, false);
        }
    }

    private static void drawLines(GuiGraphics guiGraphics, List<String> lines, boolean leftSide) {
        Font font = Minecrft.get().font;
        int y = 2;
        for (String line : lines) {
            if (Strings.isNullOrEmpty((String)line)) {
                Objects.requireNonNull(font);
                y += 9;
                continue;
            }
            boolean splitted = false;
            for (FormattedCharSequence chars : font.split(FormattedText.of((String)line), Minecrft.get().getWindow().getWidth() / zoom - 4)) {
                int x;
                int lineWidth = font.width(chars);
                int n = x = leftSide ? 2 : guiGraphics.guiWidth() - 2 - lineWidth;
                if (splitted) {
                    x += 4;
                }
                Objects.requireNonNull(font);
                guiGraphics.fill(x - 1, y - 1, x + lineWidth + 1, y + 9 - 1, -1873784752);
                guiGraphics.drawString(font, chars, x, y, -2039584, false);
                Objects.requireNonNull(font);
                y += 9;
                splitted = true;
            }
        }
    }

    public static boolean onMousePress(int button, int action, int modifiers) {
        if (!BuggerDebugScreen.active()) {
            return false;
        }
        if (Minecraft.getInstance().screen != null) {
            return false;
        }
        if (button == 2 && Screen.hasShiftDown()) {
            scroll = 0;
            return true;
        }
        if (button == 2 && Screen.hasControlDown()) {
            zoom = (int)Minecrft.get().getWindow().getGuiScale();
            return true;
        }
        return currentPage.onMousePress(button, action, modifiers);
    }

    public static boolean onMouseScroll(double amount) {
        if (!BuggerDebugScreen.active()) {
            return false;
        }
        if (Minecraft.getInstance().screen != null) {
            return false;
        }
        if (Screen.hasShiftDown()) {
            scroll = Math.max(scroll - (int)amount * 3, 0);
            return true;
        }
        if (Screen.hasControlDown()) {
            if (amount > 0.0) {
                BuggerDebugScreen.zoomIn();
            } else {
                BuggerDebugScreen.zoomOut();
            }
            return true;
        }
        return currentPage.onMouseScroll(amount);
    }

    private static void zoomIn() {
        zoom = Mth.clamp((int)(zoom + 1), (int)1, (int)8);
    }

    private static void zoomOut() {
        zoom = Mth.clamp((int)(zoom - 1), (int)1, (int)8);
    }

    public static boolean onKeyAction(int action, int key, int scanCode, int modifiers) {
        if (!BuggerDebugScreen.active()) {
            return false;
        }
        if (Minecraft.getInstance().screen != null) {
            return false;
        }
        return action == 1 && BuggerDebugScreen.onKeyPress(key, scanCode, modifiers) || action == 2 && BuggerDebugScreen.onKeyRepeat(key, scanCode, modifiers) || action == 0 && BuggerDebugScreen.onKeyRelease(key, scanCode, modifiers);
    }

    public static boolean onKeyPress(int key, int scanCode, int modifiers) {
        if (currentPage.onKeyPress(key, scanCode, modifiers)) {
            return true;
        }
        if (key == 263) {
            BuggerDebugScreen.prevPage();
            return true;
        }
        if (key == 262) {
            BuggerDebugScreen.nextPage();
            return true;
        }
        if (key == 264) {
            scroll = Math.max(scroll + 3, 0);
            return true;
        }
        if (key == 265) {
            scroll = Math.max(scroll - 3, 0);
            return true;
        }
        if (key == 268) {
            scroll = 0;
            return true;
        }
        if (key == 269) {
            scroll = Integer.MAX_VALUE;
            return true;
        }
        if (key == 260 && Screen.hasControlDown()) {
            BuggerDebugScreen.test();
            return true;
        }
        if ((key == 334 || key == 61) && Screen.hasControlDown()) {
            BuggerDebugScreen.zoomIn();
            return true;
        }
        if ((key == 333 || key == 45) && Screen.hasControlDown()) {
            BuggerDebugScreen.zoomOut();
            return true;
        }
        return false;
    }

    public static boolean onKeyRepeat(int key, int scanCode, int modifiers) {
        if (currentPage.onKeyRepeat(key, scanCode, modifiers)) {
            return true;
        }
        if (key == 263) {
            BuggerDebugScreen.prevPage();
            return true;
        }
        if (key == 262) {
            BuggerDebugScreen.nextPage();
            return true;
        }
        if (key == 264) {
            scroll = Math.max(scroll + 3, 0);
            return true;
        }
        if (key == 265) {
            scroll = Math.max(scroll - 3, 0);
            return true;
        }
        if ((key == 334 || key == 61) && Screen.hasControlDown()) {
            BuggerDebugScreen.zoomIn();
            return true;
        }
        if ((key == 333 || key == 45) && Screen.hasControlDown()) {
            BuggerDebugScreen.zoomOut();
            return true;
        }
        return false;
    }

    public static boolean onKeyRelease(int key, int scanCode, int modifiers) {
        return currentPage.onKeyRelease(key, scanCode, modifiers);
    }

    private static void test() {
        boolean a = true;
    }

    static {
        zoom = 0;
        pages.add(new LogPage());
        pages.add(new VanillaDebugPage());
        pages.add(new DataPage());
        currentPageIndex = 1;
        currentPage = pages.get(1);
        currentPage.activated();
    }
}

