/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.util.bugger.page;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.mortuusars.envelope.client.util.Minecrft;
import io.github.mortuusars.envelope.util.bugger.JsonSyntaxHighlighter;
import io.github.mortuusars.envelope.util.bugger.page.BuggerPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class DataPage
implements BuggerPage {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    @Override
    public String getTitle() {
        return "Data";
    }

    @Override
    public List<String> getLeftLines() {
        BlockHitResult blockHitResult;
        @Nullable HitResult hitResult = Minecrft.get().hitResult;
        ArrayList<String> lines = new ArrayList<String>();
        if (hitResult instanceof BlockHitResult && (blockHitResult = (BlockHitResult)hitResult).getType() != HitResult.Type.MISS) {
            BlockPos pos = blockHitResult.getBlockPos();
            Block block = Minecrft.level().getBlockState(pos).getBlock();
            lines.add(block.getName().getString());
            lines.add(BuiltInRegistries.BLOCK.getKey((Object)block).toString());
            lines.add("");
            BlockEntity blockEntity = Minecrft.level().getBlockEntity(pos);
            if (blockEntity instanceof BlockEntity) {
                BlockEntity be = blockEntity;
                CompoundTag nbt = be.saveWithFullMetadata((HolderLookup.Provider)Minecrft.level().registryAccess());
                lines.addAll(this.highlightAndSplitJson((DataResult<JsonElement>)CompoundTag.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)nbt)));
            }
            return lines;
        }
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            Entity entity = entityHitResult.getEntity();
            lines.add(entity.getName().getString());
            lines.add(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).toString());
            lines.add("");
            CompoundTag nbt = (CompoundTag)Util.make((Object)new CompoundTag(), arg_0 -> ((Entity)entity).save(arg_0));
            lines.addAll(this.highlightAndSplitJson((DataResult<JsonElement>)CompoundTag.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)nbt)));
            return lines;
        }
        ItemStack itemInHand = this.getItemInHand();
        lines.add(itemInHand.getHoverName().getString());
        lines.add(BuiltInRegistries.ITEM.getKey((Object)itemInHand.getItem()).toString());
        lines.add("");
        DataResult encodeResult = ItemStack.CODEC.encodeStart((DynamicOps)Minecrft.registryAccess().createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)itemInHand);
        lines.addAll(this.highlightAndSplitJson((DataResult<JsonElement>)encodeResult));
        return lines;
    }

    protected List<String> highlightAndSplitJson(DataResult<JsonElement> encodingResult) {
        JsonElement json = (JsonElement)encodingResult.result().orElse(new JsonObject());
        String jsonString = JsonSyntaxHighlighter.highlight(GSON.toJson(json));
        return Arrays.asList(jsonString.split("\n"));
    }

    @Override
    public List<String> getRightLines() {
        BlockHitResult blockHitResult;
        @Nullable HitResult hitResult = Minecrft.get().hitResult;
        if (hitResult instanceof BlockHitResult && (blockHitResult = (BlockHitResult)hitResult).getType() != HitResult.Type.MISS) {
            return Minecrft.level().getBlockState(blockHitResult.getBlockPos()).getTags().map(key -> "#" + String.valueOf(key.location())).toList();
        }
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            return entityHitResult.getEntity().getType().builtInRegistryHolder().tags().map(key -> "#" + String.valueOf(key.location())).toList();
        }
        return this.getItemInHand().getTags().map(key -> "#" + String.valueOf(key.location())).toList();
    }

    private ItemStack getItemInHand() {
        @Nullable LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return ItemStack.EMPTY;
        }
        ItemStack mainHandItem = player.getItemInHand(InteractionHand.MAIN_HAND);
        return mainHandItem.isEmpty() ? player.getItemInHand(InteractionHand.OFF_HAND) : mainHandItem;
    }
}

