/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.util.bugger.page;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.envelope.util.bugger.page.BuggerPage;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class LogPage
implements BuggerPage {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ArrayList<String> log = new ArrayList();
    @Nullable
    private LogFileTailer tailer;
    private final Path logFile = Paths.get(".", new String[0]).resolve("logs").resolve("latest.log");

    @Override
    public String getTitle() {
        return "Log";
    }

    @Override
    public void activated() {
        if (this.tailer == null) {
            this.tailer = new LogFileTailer(this.logFile, line -> {
                if (!(line = this.process((String)line)).isEmpty()) {
                    this.log.add((String)line);
                }
            });
            this.tailer.start();
        }
    }

    @Override
    public void deactivated() {
        if (this.tailer != null) {
            this.tailer.stop();
            this.tailer = null;
        }
    }

    private String process(String line) {
        while (this.log.size() > 1000) {
            this.log.removeFirst();
        }
        if (line.contains("Saving chunks for level")) {
            return "";
        }
        try {
            List<String> parts = this.extractParts(line);
            String date = parts.getFirst();
            date = date.substring(date.indexOf(32) + 1, date.length() - 4);
            String threadAndLevel = parts.get(1);
            threadAndLevel = threadAndLevel.replace(" thread", "");
            String thread = threadAndLevel.substring(0, threadAndLevel.indexOf("/"));
            String level = threadAndLevel.substring(threadAndLevel.indexOf("/") + 1);
            String callingClass = parts.get(2);
            callingClass = callingClass.substring(callingClass.lastIndexOf(46) + 1, callingClass.length() - 1);
            String message = line.substring(line.indexOf("]: ") + 3);
            String color = switch (level) {
                case "WARN" -> ChatFormatting.YELLOW.toString();
                case "ERROR" -> ChatFormatting.RED.toString();
                default -> "";
            };
            return String.format("[%s] [%s/%s%s\u00a7r] [%s]: %s", date, thread, color, level, callingClass, message);
        }
        catch (Exception e) {
            return line;
        }
    }

    List<String> extractParts(String input) {
        ArrayList<String> parts = new ArrayList<String>();
        Matcher matcher = Pattern.compile("\\[(.*?)]").matcher(input);
        while (matcher.find()) {
            parts.add(matcher.group(1));
        }
        return parts;
    }

    @Override
    public List<String> getLeftLines() {
        if (this.log.isEmpty()) {
            return List.of("[Ctrl+O]: Open latest.log");
        }
        return this.log;
    }

    @Override
    public boolean onKeyPress(int key, int scanCode, int modifiers) {
        if (key == 79 && Screen.hasControlDown()) {
            Util.getPlatform().openFile(this.logFile.toFile());
            return true;
        }
        return false;
    }

    public static class LogFileTailer {
        private final Path logPath;
        private final Consumer<String> lineConsumer;
        private ScheduledExecutorService scheduledExecutor;
        private Thread watchThread;
        private volatile boolean running = false;
        private RandomAccessFile raf = null;
        private long lastKnownLength = 0L;

        public LogFileTailer(Path logPath, Consumer<String> lineConsumer) {
            this.logPath = logPath;
            this.lineConsumer = lineConsumer;
        }

        public synchronized void start() {
            if (this.running) {
                return;
            }
            this.running = true;
            this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
                Thread t = new Thread(r, "log-tailer-poller");
                t.setDaemon(true);
                return t;
            });
            this.scheduledExecutor.scheduleWithFixedDelay(() -> {
                try {
                    this.poll();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }, 0L, 300L, TimeUnit.MILLISECONDS);
            this.watchThread = new Thread(this::watchLoop, "log-tailer-watcher");
            this.watchThread.setDaemon(true);
            this.watchThread.start();
        }

        public synchronized void stop() {
            this.running = false;
            if (this.scheduledExecutor != null) {
                this.scheduledExecutor.shutdownNow();
                this.scheduledExecutor = null;
            }
            if (this.watchThread != null) {
                this.watchThread.interrupt();
                this.watchThread = null;
            }
            if (this.raf != null) {
                try {
                    this.raf.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.raf = null;
            }
        }

        private void poll() {
            try {
                this.tailFile();
            }
            catch (Throwable t) {
                LOGGER.error("poll error: ", t);
            }
        }

        private synchronized void tailFile() throws IOException {
            if (this.raf == null) {
                this.openForTail();
            }
            if (this.raf == null) {
                return;
            }
            long fileLength = this.raf.length();
            if (fileLength < this.lastKnownLength) {
                this.reopenForTail();
                fileLength = this.raf.length();
            }
            if (fileLength > this.lastKnownLength) {
                String line;
                this.raf.seek(this.lastKnownLength);
                while ((line = this.raf.readLine()) != null) {
                    try {
                        this.lineConsumer.accept(new String(line.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8));
                    }
                    catch (Exception e) {
                        this.lineConsumer.accept(line);
                    }
                }
                this.lastKnownLength = this.raf.getFilePointer();
            }
        }

        private void openForTail() throws IOException {
            if (!Files.exists(this.logPath, new LinkOption[0])) {
                return;
            }
            this.raf = new RandomAccessFile(this.logPath.toFile(), "r");
            this.lastKnownLength = this.raf.length();
            this.raf.seek(this.lastKnownLength);
        }

        private void reopenForTail() throws IOException {
            if (this.raf != null) {
                try {
                    this.raf.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.raf = null;
            }
            this.openForTail();
        }

        private void watchLoop() {
            try (WatchService ws = FileSystems.getDefault().newWatchService();){
                Path parent = this.logPath.getParent();
                if (parent == null) {
                    return;
                }
                parent.register(ws, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                while (this.running && !Thread.currentThread().isInterrupted()) {
                    WatchKey key;
                    try {
                        key = ws.poll(500L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                    if (key == null) continue;
                    for (WatchEvent<?> ev : key.pollEvents()) {
                        Path changed = (Path)ev.context();
                        if (changed == null || !changed.endsWith(this.logPath.getFileName())) continue;
                        try {
                            this.reopenForTail();
                        }
                        catch (IOException iOException) {}
                    }
                    key.reset();
                }
            }
            catch (IOException e) {
                LOGGER.error("watchLoop error: ", (Throwable)e);
            }
        }
    }
}

