/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.util.bugger.test.cases;

import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.util.bugger.test.BuggerTests;
import io.github.mortuusars.envelope.util.bugger.test.Test;
import io.github.mortuusars.envelope.world.inventory.RequestedItem;
import io.github.mortuusars.envelope.world.mail.address.Address;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class RequestedItemTests
extends BuggerTests {
    private final MinecraftServer server;

    public RequestedItemTests(MinecraftServer server) {
        this.server = server;
        this.itemMatching();
        this.tagMatching();
        this.componentMatching();
        this.matchingItemFromJson();
        this.matchingTagFromJson();
        this.matchingItemWithComponentsFromJson();
    }

    private void itemMatching() {
        RequestedItem requestedItem = new RequestedItem((ItemLike)Items.FEATHER, 3);
        this.add("RequestedItem_simpleMatching", Test.isTrue(() -> requestedItem.matches(new ItemStack((ItemLike)Items.FEATHER, 3))));
        this.add("RequestedItem_simpleMatching_failsWhenItemIsDifferent", Test.isFalse(() -> requestedItem.matches(new ItemStack((ItemLike)Items.WRITTEN_BOOK, 3))));
        this.add("RequestedItem_simpleMatching_failsWhenCountIsLesser", Test.isFalse(() -> requestedItem.matches(new ItemStack((ItemLike)Items.FEATHER, 1))));
        this.add("RequestedItem_simpleMatching_failsWhenMoreThanCount", Test.isFalse(() -> requestedItem.matches(new ItemStack((ItemLike)Items.FEATHER, 5))));
        ItemStack stack = new ItemStack((ItemLike)Items.FEATHER, 3);
        stack.set(Envelope.DataComponents.LETTER_TATTERED, (Object)Unit.INSTANCE);
        stack.set(Envelope.DataComponents.PACKAGE_TIMES_PACKED, (Object)5);
        this.add("RequestedItem_simpleMatching_withRandomComponents", Test.isTrue(() -> requestedItem.matches(stack)));
    }

    private void tagMatching() {
        RequestedItem requestedItem = new RequestedItem((TagKey<Item>)ItemTags.LOGS, 12);
        this.add("RequestedItem_simpleMatching", Test.isTrue(() -> requestedItem.matches(new ItemStack((ItemLike)Items.OAK_LOG, 12))));
        this.add("RequestedItem_simpleMatching_failsWhenItemIsDifferent", Test.isFalse(() -> requestedItem.matches(new ItemStack((ItemLike)Items.WRITTEN_BOOK, 20))));
        this.add("RequestedItem_simpleMatching_failsWhenCountIsLesser", Test.isFalse(() -> requestedItem.matches(new ItemStack((ItemLike)Items.OAK_LOG, 5))));
        this.add("RequestedItem_simpleMatching_failsWhenMoreThanCount", Test.isFalse(() -> requestedItem.matches(new ItemStack((ItemLike)Items.OAK_LOG, 30))));
        ItemStack stack = new ItemStack((ItemLike)Items.OAK_LOG, 12);
        stack.set(Envelope.DataComponents.LETTER_TATTERED, (Object)Unit.INSTANCE);
        stack.set(Envelope.DataComponents.PACKAGE_TIMES_PACKED, (Object)5);
        this.add("RequestedItem_simpleMatching_withRandomComponents", Test.isTrue(() -> requestedItem.matches(stack)));
    }

    private void componentMatching() {
        RequestedItem requestedItem = new RequestedItem((ItemLike)Items.FEATHER, 3, DataComponentPredicate.builder().expect(Envelope.DataComponents.MAIL_SENDER, (Object)Address.MAIL_SERVICE).expect(Envelope.DataComponents.LETTER_TATTERED, (Object)Unit.INSTANCE).expect(Envelope.DataComponents.PACKAGE_TIMES_PACKED, (Object)5).build());
        ItemStack stack = new ItemStack((ItemLike)Items.FEATHER, 3);
        stack.set(Envelope.DataComponents.MAIL_SENDER, (Object)Address.MAIL_SERVICE);
        stack.set(Envelope.DataComponents.LETTER_TATTERED, (Object)Unit.INSTANCE);
        stack.set(Envelope.DataComponents.PACKAGE_TIMES_PACKED, (Object)5);
        this.add("RequestedItem_componentMatching", Test.isTrue(() -> requestedItem.matches(stack)));
        ItemStack stack2 = stack.copy();
        stack2.remove(Envelope.DataComponents.MAIL_SENDER);
        this.add("RequestedItem_componentMatching_failsWhenMissing", Test.isFalse(() -> requestedItem.matches(stack2)));
    }

    private void matchingItemFromJson() {
        this.add("RequestedItem_matchingItemFromJson_simple", Test.isTrue(() -> RequestedItemTests.decodeFromJson("{\"item\":\"minecraft:emerald\"}").matches(new ItemStack((ItemLike)Items.EMERALD))));
        this.add("RequestedItem_matchingItemFromJson_failsWhenCountIsLesser", Test.isFalse(() -> RequestedItemTests.decodeFromJson("{\"item\":\"minecraft:emerald\",\"count\":5}").matches(new ItemStack((ItemLike)Items.EMERALD))));
    }

    private void matchingItemWithComponentsFromJson() {
        String json = "{\n  \"item\": \"minecraft:emerald\",\n  \"count\": 3,\n  \"components\": {\n    \"envelope:letter_tattered\": {},\n    \"envelope:mail_sender\": {\n        \"type\": \"entity\",\n        \"id\": \"Mail Service\"\n    },\n    \"envelope:mail_recipient\": {\n        \"type\": \"block\",\n        \"id\": \"Mortuusars Laboratory\"\n    }\n  }\n}\n";
        this.add("RequestedItem_matchingItemWithComponentsFromJson_simple", Test.isTrue(() -> {
            ItemStack stack = new ItemStack((ItemLike)Items.EMERALD, 3);
            stack.set(Envelope.DataComponents.LETTER_TATTERED, (Object)Unit.INSTANCE);
            stack.set(Envelope.DataComponents.MAIL_SENDER, (Object)Address.MAIL_SERVICE);
            stack.set(Envelope.DataComponents.MAIL_RECIPIENT, (Object)new Address.Block("Mortuusars Laboratory"));
            return RequestedItemTests.decodeFromJson(json).matches(stack);
        }));
    }

    private void matchingTagFromJson() {
        this.add("RequestedItem_matchingTagFromJson_simple", Test.isTrue(() -> RequestedItemTests.decodeFromJson("{\"item\":\"#minecraft:planks\"}").matches(new ItemStack((ItemLike)Items.BIRCH_PLANKS))));
        this.add("RequestedItem_matchingTagFromJson_failsWhenCountIsLesser", Test.isFalse(() -> RequestedItemTests.decodeFromJson("{\"item\":\"#minecraft:planks\",\"count\":5}").matches(new ItemStack((ItemLike)Items.BIRCH_PLANKS))));
    }

    private static RequestedItem decodeFromJson(String json) {
        JsonObject obj = GsonHelper.parse((String)json);
        return (RequestedItem)RequestedItem.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)obj).getOrThrow();
    }
}

