/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.util.bugger_data;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.util.bugger.data.NbtData;
import io.github.mortuusars.envelope.world.delivery.Courier;
import io.github.mortuusars.envelope.world.delivery.Delivery;
import io.github.mortuusars.envelope.world.delivery.background.BackgroundCourier;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import io.github.mortuusars.envelope.world.service.MailService;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.entity.EntityTypeTest;
import org.jetbrains.annotations.NotNull;

public class MailServiceBuggerData
extends NbtData {
    public MailServiceBuggerData() {
        super(Envelope.resource("mail_service"));
    }

    public void collectAndSendData(MailService mailService) {
        this.sendValues(tag -> this.writeDebugInfo(mailService, (CompoundTag)tag));
    }

    private void writeDebugInfo(MailService mailService, CompoundTag tag) {
        List pigeons = mailService.getLevel().getEntities(EntityTypeTest.forClass(Pigeon.class), Pigeon::isDelivering);
        List<BackgroundCourier> backgroundCouriers = mailService.getBackgroundDelivery().getCouriers();
        tag.putInt("mailboxes", mailService.getMailboxes().getAllAddresses().size());
        tag.putInt("payback_pending_mail", mailService.getPaybackDepartment().getPendingPaybackSubjectCount());
        tag.putInt("delivering_pigeons", pigeons.size());
        tag.putInt("background_delivering_pigeons", backgroundCouriers.size());
        tag.putInt("background_finished_pigeons", mailService.getBackgroundDelivery().getFinishedCouriers().size());
        ListTag deliveries = Stream.concat(pigeons.stream(), backgroundCouriers.stream()).sorted(Comparator.comparingLong(courier -> courier.getCurrentDelivery().orElseThrow().getId().getTick())).map(courier -> this.formDeliveryString(mailService, (Courier)courier)).map(StringTag::valueOf).collect(Collectors.toCollection(ListTag::new));
        tag.put("deliveries", (Tag)deliveries);
    }

    @NotNull
    private String formDeliveryString(MailService mailService, Courier courier) {
        Delivery delivery = courier.getCurrentDelivery().orElseThrow();
        int phaseDuration = courier.getDeliveryHandler().getPhaseDuration(mailService.getLevel(), delivery, delivery.getPhase());
        return String.valueOf(ChatFormatting.AQUA) + delivery.getSender().format().withIcon().toString() + String.valueOf(ChatFormatting.RESET) + " \uee21 " + String.valueOf(ChatFormatting.GREEN) + delivery.getRecipient().format().withIcon().toString() + String.valueOf(ChatFormatting.RESET) + String.valueOf(ChatFormatting.GRAY) + " | " + (courier.getOrigin().isService() ? "Service" : "Regular") + " | \u2709 " + (!delivery.getMail().isEmpty() ? delivery.getMail().getHoverName().getString() : "Empty") + " | \u2194 " + delivery.getRoute().getDistance().map(i -> Integer.toString(i)).orElse("?") + " | \u231a" + delivery.getRoute().getFullTravelDuration().seconds() + "s" + String.valueOf(ChatFormatting.RESET) + " // " + delivery.getPhase().toPrettyString() + String.valueOf(ChatFormatting.GRAY) + " \u231b" + (phaseDuration - delivery.getPhaseProgress()) / 20 + String.valueOf(ChatFormatting.RESET);
    }
}

