/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.util.bugger_data;

import io.github.mortuusars.envelope.util.bugger.BuggerEntityOverhead;
import io.github.mortuusars.envelope.world.delivery.Delivery;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import io.github.mortuusars.envelope.world.entity.ai.MailboxHandler;
import io.github.mortuusars.envelope.world.entity.ai.PigeonholeHandler;
import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;

public class PigeonEntityDataDisplay
implements BuggerEntityOverhead.EntityDataDisplay {
    @Override
    public void addLines(Entity entity, ArrayList<Component> lines) {
        if (!(entity instanceof Pigeon)) {
            return;
        }
        Pigeon pigeon = (Pigeon)entity;
        if (pigeon.getCurrentDelivery().isPresent()) {
            Delivery delivery = pigeon.getCurrentDelivery().get();
            lines.add((Component)Component.empty().append((Component)delivery.getSender().getName()).append(" \u2192 ").append((Component)delivery.getRecipient().getName()));
            lines.add(this.line(delivery.getPhase().toPrettyString()));
            return;
        }
        if (pigeon.isTired()) {
            lines.add(this.line("Tired"));
        }
        PigeonholeHandler pigeonholeHandler = pigeon.getPigeonholeHandler();
        MailboxHandler mailboxHandler = pigeon.getMailboxHandler();
        if (mailboxHandler.getTargetPos() != null) {
            lines.add(this.line("Going to Mailbox for pickup"));
        }
        if (pigeonholeHandler.wantsToEnterPigeonhole(pigeon)) {
            lines.add(this.line(pigeonholeHandler.getTargetPos() != null ? "Going to Pigeonhole" : "Looking for Pigeonhole"));
        } else {
            lines.add(this.line("Would want to enter after: " + pigeonholeHandler.getWantCooldown() / 20));
            if (pigeonholeHandler.getEnterCooldown() > 0) {
                lines.add(this.line("Could enter after: " + pigeonholeHandler.getEnterCooldown() / 20));
            }
        }
    }
}

