/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.util.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import org.jetbrains.annotations.NotNull;

public class WeightedComponent
implements WeightedEntry {
    public static final Codec<WeightedComponent> FULL_CODEC = RecordCodecBuilder.create(i -> i.group((App)ComponentSerialization.CODEC.optionalFieldOf("component", (Object)Component.empty()).forGetter(WeightedComponent::getComponent), (App)Weight.CODEC.optionalFieldOf("weight", (Object)Weight.of((int)1)).forGetter(WeightedComponent::getWeight)).apply((Applicative)i, WeightedComponent::new));
    public static final Codec<WeightedComponent> CODEC = Codec.either((Codec)ComponentSerialization.CODEC, FULL_CODEC).xmap(regularOrWeighted -> (WeightedComponent)regularOrWeighted.map(WeightedComponent::new, Function.identity()), WeightedComponent::asEither);
    private final Component component;
    private final Weight weight;

    public WeightedComponent(Component component, Weight weight) {
        this.component = component;
        this.weight = weight;
    }

    public WeightedComponent(Component component) {
        this.component = component;
        this.weight = Weight.of((int)1);
    }

    public Component getComponent() {
        return this.component;
    }

    @NotNull
    public Weight getWeight() {
        return this.weight;
    }

    public Either<Component, WeightedComponent> asEither() {
        if (this.getWeight().asInt() <= 1) {
            return Either.left((Object)this.getComponent());
        }
        return Either.right((Object)this);
    }
}

