/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.util.result;

import com.mojang.serialization.DataResult;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class Error {
    protected final String message;
    @Nullable
    protected final String translationKey;

    public Error(String message, @Nullable String translationKey) {
        this.message = message;
        this.translationKey = translationKey;
    }

    public Error(String message) {
        this(message, null);
    }

    public String getMessage() {
        return this.message;
    }

    public MutableComponent getTranslation() {
        return this.translationKey != null ? Component.translatable((String)this.translationKey) : Component.literal((String)this.message);
    }

    public void log(Logger logger) {
        logger.error(this.getMessage());
    }

    public <T> DataResult<T> asDataResult() {
        return DataResult.error(this::getMessage);
    }

    public String toString() {
        return this.getMessage();
    }
}

