/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.util.result;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.mojang.serialization.DataResult;
import io.github.mortuusars.envelope.util.result.Error;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Result<T> {
    @Nullable
    protected final T value;
    @Nullable
    protected final Error error;

    protected Result(@Nullable T value, @Nullable Error error) {
        Preconditions.checkArgument((value != null && error == null || value == null && error != null ? 1 : 0) != 0, (Object)"Only value or error can exist at once, not both.");
        this.value = value;
        this.error = error;
    }

    public static <T> Result<T> success(@NotNull T value) {
        Preconditions.checkNotNull(value);
        return new Result<T>(value, null);
    }

    public static <T> Result<T> error(@NotNull Error error) {
        Preconditions.checkNotNull((Object)error);
        return new Result<Object>(null, error);
    }

    public static <T> Result<T> error(@NotNull String errorMessage, @Nullable String errorTranslationKey) {
        Preconditions.checkNotNull((Object)errorMessage);
        return new Result<Object>(null, new Error(errorMessage, errorTranslationKey));
    }

    public static <T> Result<T> error(@NotNull String errorMessage) {
        return Result.error(errorMessage, null);
    }

    public boolean isSuccess() {
        return this.value != null;
    }

    public boolean isError() {
        return this.error != null;
    }

    public Optional<T> getValue() {
        return Optional.ofNullable(this.value);
    }

    public T getValueOrElse(T orElse) {
        return this.value != null ? this.value : orElse;
    }

    public T getValueOrElseGet(Supplier<T> orElseSupplier) {
        return (T)(this.value != null ? this.value : orElseSupplier.get());
    }

    public Optional<Error> getError() {
        return Optional.ofNullable(this.error);
    }

    public Result<T> ifPresent(Consumer<T> consumer) {
        if (this.isSuccess()) {
            consumer.accept(this.value);
        }
        return this;
    }

    public Result<T> ifPresentOrElse(Consumer<T> consumer, Consumer<Error> errorConsumer) {
        if (this.isSuccess()) {
            consumer.accept(this.value);
        } else {
            errorConsumer.accept(this.error);
        }
        return this;
    }

    public Result<T> ifError(Consumer<Error> consumer) {
        if (this.isError()) {
            consumer.accept(this.error);
        }
        return this;
    }

    public Result<T> filter(Function<T, Result<T>> filter) {
        return this.getValue().map(filter).orElse(this);
    }

    public <R> R map(Function<T, R> ifValue, Function<Error, R> ifError) {
        return this.isSuccess() ? ifValue.apply(this.value) : ifError.apply(this.error);
    }

    public <R> Result<R> mapValue(Function<T, R> valueMapper) {
        return this.isSuccess() ? Result.success(valueMapper.apply(this.value)) : Result.error(this.error);
    }

    public Result<T> mapError(Function<Error, Error> errorMapper) {
        return this.isError() ? Result.error(errorMapper.apply(this.error)) : this;
    }

    public T handleError(Consumer<Error> errorConsumer, T value) {
        if (this.isError()) {
            errorConsumer.accept(this.error);
        }
        return this.getValueOrElse(value);
    }

    public DataResult<T> asDataResult() {
        return this.map(DataResult::success, error -> DataResult.error(error::getMessage));
    }
}

