/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.util.validation;

import io.github.mortuusars.envelope.util.result.Error;
import java.util.Optional;
import java.util.function.Predicate;

public interface Rule<T> {
    public Optional<Error> test(T var1);

    public static <T> Rule<T> when(Predicate<T> predicate, Error issue) {
        return new SimpleRule<T>(predicate, issue);
    }

    public record SimpleRule<T>(Predicate<T> predicate, Error issue) implements Rule<T>
    {
        @Override
        public Optional<Error> test(T value) {
            return this.predicate.test(value) ? Optional.of(this.issue) : Optional.empty();
        }
    }
}

