/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world;

import java.util.ArrayList;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;

public interface GameTime {
    public long get();

    public static GameTime of(Level level) {
        return () -> ((Level)level).getGameTime();
    }

    public static GameTime at(long tick) {
        return () -> tick;
    }

    default public GameTime fromNow(GameTime time) {
        return () -> this.get() + time.get();
    }

    default public GameTime fromNow(long ticks) {
        return () -> this.get() + ticks;
    }

    default public boolean hasPassed(GameTime time) {
        return this.hasPassed(time.get());
    }

    default public boolean hasPassed(long tick) {
        return this.get() > tick;
    }

    default public GameTime elapsedSince(GameTime time) {
        return () -> this.get() - time.get();
    }

    default public GameTime elapsedSince(long tick) {
        return () -> this.get() - tick;
    }

    default public GameTime remainingTo(GameTime time) {
        return () -> time.get() - this.get();
    }

    default public GameTime remainingTo(long tick) {
        return () -> tick - this.get();
    }

    default public MutableComponent format(boolean withSeconds) {
        return GameTime.format(this.get(), withSeconds);
    }

    default public MutableComponent formatLargest(boolean withSeconds) {
        return GameTime.formatLargest(this.get(), withSeconds);
    }

    public static MutableComponent format(long ticks, boolean withSeconds) {
        long secondsTotal = ticks / 20L;
        long years = secondsTotal / 31104000L;
        long months = (secondsTotal %= 31104000L) / 2592000L;
        long weeks = (secondsTotal %= 2592000L) / 604800L;
        long days = (secondsTotal %= 604800L) / 86400L;
        long hours = (secondsTotal %= 86400L) / 3600L;
        long minutes = (secondsTotal %= 3600L) / 60L;
        long seconds = secondsTotal %= 60L;
        ArrayList<MutableComponent> parts = new ArrayList<MutableComponent>();
        if (years > 0L) {
            parts.add(Component.translatable((String)"gui.envelope.time.years", (Object[])new Object[]{years}));
        }
        if (months > 0L) {
            parts.add(Component.translatable((String)"gui.envelope.time.months", (Object[])new Object[]{months}));
        }
        if (weeks > 0L) {
            parts.add(Component.translatable((String)"gui.envelope.time.weeks", (Object[])new Object[]{weeks}));
        }
        if (days > 0L) {
            parts.add(Component.translatable((String)"gui.envelope.time.days", (Object[])new Object[]{days}));
        }
        if (hours > 0L) {
            parts.add(Component.translatable((String)"gui.envelope.time.hours", (Object[])new Object[]{hours}));
        }
        if (minutes > 0L) {
            parts.add(Component.translatable((String)"gui.envelope.time.minutes", (Object[])new Object[]{minutes}));
        }
        if (withSeconds) {
            if (seconds > 0L) {
                parts.add(Component.translatable((String)"gui.envelope.time.seconds", (Object[])new Object[]{seconds}));
            } else {
                parts.add(Component.translatable((String)"gui.envelope.time.less_than_one_second"));
            }
        }
        if (parts.isEmpty()) {
            parts.add(Component.translatable((String)"gui.envelope.time.less_than_one_minute"));
        }
        MutableComponent result = Component.empty();
        for (int i = 0; i < parts.size(); ++i) {
            if (i > 0) {
                result.append(CommonComponents.SPACE);
            }
            result.append((Component)parts.get(i));
        }
        return result;
    }

    public static MutableComponent formatLargest(long ticks, boolean withSeconds) {
        long secondsTotal = ticks / 20L;
        long years = secondsTotal / 31104000L;
        if (years > 0L) {
            return Component.translatable((String)"gui.envelope.time.years", (Object[])new Object[]{years});
        }
        long months = (secondsTotal %= 31104000L) / 2592000L;
        if (months > 0L) {
            return Component.translatable((String)"gui.envelope.time.months", (Object[])new Object[]{months});
        }
        long weeks = (secondsTotal %= 2592000L) / 604800L;
        if (weeks > 0L) {
            return Component.translatable((String)"gui.envelope.time.weeks", (Object[])new Object[]{weeks});
        }
        long days = (secondsTotal %= 604800L) / 86400L;
        if (days > 0L) {
            return Component.translatable((String)"gui.envelope.time.days", (Object[])new Object[]{days});
        }
        long hours = (secondsTotal %= 86400L) / 3600L;
        if (hours > 0L) {
            return Component.translatable((String)"gui.envelope.time.hours", (Object[])new Object[]{hours});
        }
        long minutes = (secondsTotal %= 3600L) / 60L;
        if (minutes > 0L) {
            return Component.translatable((String)"gui.envelope.time.minutes", (Object[])new Object[]{minutes});
        }
        long seconds = secondsTotal %= 60L;
        if (withSeconds) {
            if (seconds > 0L) {
                return Component.translatable((String)"gui.envelope.time.minutes", (Object[])new Object[]{minutes});
            }
            return Component.translatable((String)"gui.envelope.time.less_than_one_second");
        }
        return Component.translatable((String)"gui.envelope.time.less_than_one_minute");
    }
}

