/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world;

import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Position {
    public static Vec3 lerp(BlockPos origin, BlockPos target, double delta) {
        double x = (double)origin.getX() + (double)(target.getX() - origin.getX()) * delta;
        double y = (double)origin.getY() + (double)(target.getY() - origin.getY()) * delta;
        double z = (double)origin.getZ() + (double)(target.getZ() - origin.getZ()) * delta;
        return new Vec3(x, y, z);
    }

    public static BlockPos snapToGrid(BlockPos pos, int size) {
        int x = Math.round((float)pos.getX() / (float)size) * size;
        int z = Math.round((float)pos.getZ() / (float)size) * size;
        return new BlockPos(x, pos.getY(), z);
    }

    public static BlockPos nearestHub(BlockPos pos) {
        return Position.snapToGrid(pos, 1024).atY(500);
    }

    public static BlockPos towardsDirection(BlockPos origin, BlockPos target, double distance) {
        Vec3 originVec = Vec3.atCenterOf((Vec3i)origin);
        Vec3 targetVec = Vec3.atCenterOf((Vec3i)target);
        Vec3 direction = targetVec.subtract(originVec).normalize();
        return BlockPos.containing((net.minecraft.core.Position)originVec.add(direction.scale(distance)));
    }

    public static BlockPos towardsHorizontalDirection(BlockPos origin, BlockPos target, double distance) {
        return Position.towardsDirection(origin, target.atY(origin.getY()), distance);
    }

    public static BlockPos towardsRandomHorizontalDirection(BlockPos origin, int distance, int seed) {
        Random random = new Random(seed);
        random.nextLong();
        double angle = random.nextDouble() * 2.0 * Math.PI;
        return origin.offset((int)(Math.cos(angle) * (double)distance), 0, (int)(Math.sin(angle) * (double)distance));
    }

    public static BlockPos ascendTowards(BlockPos origin, BlockPos target, int distance) {
        return Position.towardsHorizontalDirection(origin, target, distance).above(distance);
    }

    public static BlockPos ascendTowards(Level level, BlockPos origin, Optional<BlockPos> target, int distance, int seed) {
        BlockPos pos = target.map(recipientPos -> Position.towardsHorizontalDirection(origin, recipientPos, distance)).orElseGet(() -> Position.towardsRandomHorizontalDirection(origin, distance, seed)).above(distance);
        return Position.aboveGround(level, pos, 5);
    }

    public static Optional<BlockPos> ascendTowards(Level level, Optional<BlockPos> origin, Optional<BlockPos> target, int distance, int seed) {
        return origin.map(pos -> Position.ascendTowards(level, pos, target, distance, seed));
    }

    @Deprecated
    public static boolean isInSafeSimulationDistance(ServerLevel level, BlockPos pos) {
        if (!level.isLoaded(pos)) {
            return false;
        }
        int simDistance = level.getServer().getPlayerList().getSimulationDistance();
        int range = simDistance - 1;
        return level.players().stream().anyMatch(player -> {
            double dz;
            double dx = Math.abs((double)pos.getX() - player.getX()) / 16.0;
            return Math.max(dx, dz = Math.abs((double)pos.getZ() - player.getZ()) / 16.0) <= (double)range;
        });
    }

    public static boolean isInSimulationDistance(ServerLevel level, ChunkPos chunkPos) {
        return level.getChunkSource().chunkMap.getDistanceManager().inEntityTickingRange(chunkPos.toLong());
    }

    public static boolean isInSimulationDistance(ServerLevel level, BlockPos pos) {
        return Position.isInSimulationDistance(level, new ChunkPos(pos));
    }

    public static boolean isInSimulationDistance(ServerLevel level, Entity entity) {
        return Position.isInSimulationDistance(level, entity.chunkPosition());
    }

    @Nullable
    public static BlockPos findNearbyHeightmapSpawnPosition(ServerLevel level, BlockPos pos, int altitude) {
        double lowestDistance = Double.MAX_VALUE;
        BlockPos closestRandomPos = null;
        for (int i = 0; i < 5; ++i) {
            double distance;
            BlockPos randomPos = Position.aboveGround((Level)level, level.getBlockRandomPos(pos.getX(), pos.getY(), pos.getZ(), 15), altitude);
            if (!Position.isInSimulationDistance(level, randomPos) || !((distance = randomPos.distSqr((Vec3i)pos)) < lowestDistance)) continue;
            lowestDistance = distance;
            closestRandomPos = randomPos;
        }
        if (closestRandomPos != null) {
            return closestRandomPos;
        }
        BlockPos blockPos = Position.aboveGround((Level)level, pos, altitude);
        if (Position.isInSimulationDistance(level, blockPos)) {
            return blockPos;
        }
        return null;
    }

    public static BlockPos aboveGround(Level level, BlockPos pos, int altitude) {
        int heightmapY = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos).getY();
        int y = Math.max(pos.getY(), heightmapY + altitude);
        return pos.getY() == y ? pos : pos.atY(y);
    }

    public static int getDistanceBetween(BlockPos a, BlockPos b) {
        return (int)Math.sqrt(a.distSqr((Vec3i)b));
    }

    public static Optional<Integer> getDistanceBetween(Optional<BlockPos> a, Optional<BlockPos> b) {
        if (a.isEmpty() || b.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Position.getDistanceBetween(a.get(), b.get()));
    }

    public static boolean isFireNearby(Level level, BlockPos pos) {
        if (level == null) {
            return false;
        }
        for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 1, 1))) {
            if (!(level.getBlockState(blockPos).getBlock() instanceof FireBlock)) continue;
            return true;
        }
        return false;
    }
}

