/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.block;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.item.PackageItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Containers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageBlockEntity
extends BlockEntity {
    protected ItemStack item = ItemStack.EMPTY;
    protected boolean unpackWhenBroken = true;

    protected PackageBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public PackageBlockEntity(BlockPos pos, BlockState blockState) {
        super(Envelope.BlockEntityTypes.PACKAGE.get(), pos, blockState);
    }

    public ItemStack getPackage() {
        return !this.item.isEmpty() ? this.item : new ItemStack((ItemLike)this.getBlockState().getBlock().asItem());
    }

    public void setPackage(ItemStack item) {
        this.item = item;
        this.setChanged();
    }

    public boolean unpackWhenBroken() {
        return this.unpackWhenBroken;
    }

    public void setUnpackWhenBroken(boolean unpackWhenBroken) {
        this.unpackWhenBroken = unpackWhenBroken;
        this.setChanged();
    }

    public void dropContents(Level level, BlockPos pos) {
        Item item;
        ItemStack packageStack = this.getPackage();
        if (this.unpackWhenBroken() && (item = packageStack.getItem()) instanceof PackageItem) {
            PackageItem packageItem = (PackageItem)item;
            packageItem.unpack(packageStack, level, pos, null).forEach(stored -> Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stored));
        } else {
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)packageStack);
        }
        this.setChanged();
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveCustomOnly(registries);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        if (!this.item.isEmpty()) {
            tag.put("Package", this.item.save(registries, (Tag)new CompoundTag()));
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        if (tag.contains("Package", 10)) {
            this.item = ItemStack.parse((HolderLookup.Provider)registries, (Tag)tag.getCompound("Package")).orElse(ItemStack.EMPTY);
        }
    }
}

