/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.block;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaperBoxBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    public static final IntegerProperty BOXES = IntegerProperty.create((String)"boxes", (int)1, (int)4);
    private static final VoxelShape[] SHAPES = new VoxelShape[8];

    public PaperBoxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(AXIS, (Comparable)Direction.Axis.X)).setValue((Property)BOXES, (Comparable)Integer.valueOf(1)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS, BOXES});
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPES[(Integer)state.getValue((Property)BOXES) - 1 + (state.getValue(AXIS) == Direction.Axis.Z ? 4 : 0)];
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos());
        if (blockstate.is((Block)this)) {
            return (BlockState)blockstate.cycle((Property)BOXES);
        }
        return (BlockState)((BlockState)this.getStateDefinition().any()).setValue(AXIS, (Comparable)context.getHorizontalDirection().getAxis());
    }

    public boolean canBeReplaced(@NotNull BlockState state, BlockPlaceContext context) {
        return !context.isSecondaryUseActive() && context.getItemInHand().getItem() == this.asItem() && (Integer)state.getValue((Property)BOXES) < 4 || super.canBeReplaced(state, context);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!player.isSecondaryUseActive()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        int boxes = (Integer)state.getValue((Property)BOXES) - 1;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (boxes <= 0) {
                level.removeBlock(pos, false);
            } else {
                level.setBlock(pos, (BlockState)state.setValue((Property)BOXES, (Comparable)Integer.valueOf(boxes)), 3);
            }
            if (!player.isCreative()) {
                player.addItem(new ItemStack((ItemLike)this.asItem()));
            }
            serverLevel.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.3f), (double)((float)pos.getZ() + 0.5f), 3, 0.2, 0.2, 0.2, 0.0);
        }
        level.playSound(player, pos, Envelope.SoundEvents.PAPER_USE.get(), SoundSource.BLOCKS, 0.9f, level.getRandom().nextFloat() * 0.1f + 0.85f + (float)boxes * 0.2f);
        return ItemInteractionResult.SUCCESS;
    }

    public boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, BlockPos pos) {
        return Block.canSupportCenter((LevelReader)level, (BlockPos)pos.below(), (Direction)Direction.UP);
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState state, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return switch ((Direction.Axis)state.getValue(AXIS)) {
                    case Direction.Axis.X -> (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    case Direction.Axis.Z -> (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
                    default -> state;
                };
            }
        }
        return state;
    }

    static {
        PaperBoxBlock.SHAPES[0] = Block.box((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)6.0, (double)12.0);
        PaperBoxBlock.SHAPES[1] = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)4.0, (double)7.0, (double)6.0, (double)13.0), (VoxelShape)Block.box((double)8.0, (double)0.0, (double)5.0, (double)15.0, (double)6.0, (double)12.0));
        PaperBoxBlock.SHAPES[2] = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)5.0, (double)7.0, (double)6.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.box((double)8.0, (double)0.0, (double)8.0, (double)15.0, (double)6.0, (double)15.0), Block.box((double)8.0, (double)0.0, (double)1.0, (double)14.0, (double)6.0, (double)7.0)});
        PaperBoxBlock.SHAPES[3] = Shapes.or((VoxelShape)SHAPES[2], (VoxelShape)Block.box((double)5.0, (double)6.0, (double)4.0, (double)11.0, (double)12.0, (double)13.0));
        PaperBoxBlock.SHAPES[4] = VoxelShapeUtils.rotate(SHAPES[0], Rotation.CLOCKWISE_90);
        PaperBoxBlock.SHAPES[5] = VoxelShapeUtils.rotate(SHAPES[1], Rotation.CLOCKWISE_90);
        PaperBoxBlock.SHAPES[6] = VoxelShapeUtils.rotate(SHAPES[2], Rotation.CLOCKWISE_90);
        PaperBoxBlock.SHAPES[7] = VoxelShapeUtils.rotate(SHAPES[3], Rotation.CLOCKWISE_90);
    }
}

