/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.block;

import com.mojang.serialization.MapCodec;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.block.PigeonholeBlockEntity;
import io.github.mortuusars.envelope.world.block.occupiable.Occupiable;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PigeonholeBlock
extends BaseEntityBlock {
    public static final MapCodec<PigeonholeBlock> CODEC = PigeonholeBlock.simpleCodec(PigeonholeBlock::new);
    public static final int MAX_WASTE_LEVEL = 5;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final IntegerProperty WASTE_LEVEL = IntegerProperty.create((String)"waste_level", (int)0, (int)5);

    public PigeonholeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WASTE_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WASTE_LEVEL});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.getValue((Property)WASTE_LEVEL);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.playerDestroy(level, player, pos, state, blockEntity, tool);
        if (blockEntity instanceof PigeonholeBlockEntity) {
            PigeonholeBlockEntity be = (PigeonholeBlockEntity)blockEntity;
            if (!EnchantmentHelper.hasTag((ItemStack)tool, (TagKey)EnchantmentTags.PREVENTS_BEE_SPAWNS_WHEN_MINING)) {
                be.releaseAllOccupants(level, pos, state, Occupiable.ReleaseReason.EMERGENCY);
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
        }
    }

    @NotNull
    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        Object object;
        Entity entity = (Entity)params.getOptionalParameter(LootContextParams.THIS_ENTITY);
        if ((entity instanceof PrimedTnt || entity instanceof Creeper || entity instanceof WitherSkull || entity instanceof WitherBoss || entity instanceof MinecartTNT) && (object = params.getOptionalParameter(LootContextParams.BLOCK_ENTITY)) instanceof PigeonholeBlockEntity) {
            PigeonholeBlockEntity be = (PigeonholeBlockEntity)object;
            be.releaseAllOccupants(be.getLevelOrThrow(), be.getBlockPos(), state, Occupiable.ReleaseReason.EMERGENCY);
        }
        return super.getDrops(state, params);
    }

    @NotNull
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BlockEntity blockEntity;
        if (level.getBlockState(neighborPos).getBlock() instanceof FireBlock && (blockEntity = level.getBlockEntity(pos)) instanceof PigeonholeBlockEntity) {
            PigeonholeBlockEntity be = (PigeonholeBlockEntity)blockEntity;
            be.releaseAllOccupants(be.getLevelOrThrow(), be.getBlockPos(), state, Occupiable.ReleaseReason.EMERGENCY);
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public void addWaste(Level level, BlockPos pos, BlockState state) {
        if (!state.hasProperty((Property)WASTE_LEVEL)) {
            return;
        }
        int waste = (Integer)state.getValue((Property)WASTE_LEVEL);
        if (waste < 5) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)WASTE_LEVEL, (Comparable)Integer.valueOf(++waste)));
        }
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is((Item)Envelope.Items.PIGEON_SPAWN_EGG.get())) {
            if (level instanceof ServerLevel) {
                PigeonholeBlockEntity blockEntity;
                ServerLevel serverLevel = (ServerLevel)level;
                BlockEntity blockEntity2 = level.getBlockEntity(pos);
                if (blockEntity2 instanceof PigeonholeBlockEntity && (blockEntity = (PigeonholeBlockEntity)blockEntity2).hasSpaceForAnotherOccupant()) {
                    Pigeon pigeon;
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                    if ((pigeon = (Pigeon)Envelope.EntityTypes.PIGEON.get().spawn(serverLevel, pos, MobSpawnType.SPAWN_EGG)) != null) {
                        blockEntity.addOccupant(pos, state, (Entity)pigeon);
                    }
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.is(Envelope.Tags.Items.WASTE_SCOOPABLE) && (Integer)state.getValue((Property)WASTE_LEVEL) >= 5) {
            if (!level.isClientSide()) {
                PigeonholeBlock.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)((Direction)state.getValue((Property)FACING)), (ItemStack)new ItemStack((ItemLike)Items.BONE_MEAL));
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)WASTE_LEVEL, (Comparable)Integer.valueOf(0)));
            }
            level.playSound(player, pos, (SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PigeonholeBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : PigeonholeBlock.createTickerHelper(blockEntityType, Envelope.BlockEntityTypes.PIGEONHOLE.get(), (lvl, blockPos, blockState, blockEntity) -> blockEntity.serverTick((ServerLevel)lvl, blockPos, state));
    }
}

