/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.block;

import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.Position;
import io.github.mortuusars.envelope.world.block.PigeonholeBlock;
import io.github.mortuusars.envelope.world.block.occupiable.Occupant;
import io.github.mortuusars.envelope.world.block.occupiable.Occupiable;
import io.github.mortuusars.envelope.world.block.occupiable.PigeonOccupiable;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class PigeonholeBlockEntity
extends BlockEntity
implements PigeonOccupiable {
    protected List<Occupant.Mutable> occupants = new ArrayList<Occupant.Mutable>();

    protected PigeonholeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public PigeonholeBlockEntity(BlockPos pos, BlockState blockState) {
        this(Envelope.BlockEntityTypes.PIGEONHOLE.get(), pos, blockState);
    }

    public void serverTick(ServerLevel level, BlockPos pos, BlockState state) {
        this.tickOccupants((Level)level, pos, state);
    }

    public void setChanged() {
        if (Position.isFireNearby(this.level, this.getBlockPos())) {
            this.releaseAllOccupants(this.getLevel(), this.getBlockPos(), this.getBlockState(), Occupiable.ReleaseReason.EMERGENCY);
        }
        super.setChanged();
    }

    @Override
    public List<Occupant.Mutable> getOccupants() {
        return this.occupants;
    }

    @Override
    public void onOccupantReleased(Level level, Entity entity, Occupiable.ReleaseReason reason) {
        if (reason == Occupiable.ReleaseReason.EMERGENCY) {
            return;
        }
        double wasteChance = this.getWasteIncreaseChanceOnRelease(entity);
        Block block = this.getBlockState().getBlock();
        if (block instanceof PigeonholeBlock) {
            PigeonholeBlock block2 = (PigeonholeBlock)block;
            if (level.random.nextDouble() < wasteChance) {
                block2.addWaste(level, this.getBlockPos(), this.getBlockState());
                this.setChanged();
            }
        }
        if (entity instanceof Pigeon) {
            Pigeon pigeon = (Pigeon)entity;
            pigeon.releasedFromPigeonhole(this.getBlockPos(), this.getBlockState(), reason);
        }
    }

    protected double getWasteIncreaseChanceOnRelease(Entity releasedEntity) {
        Pigeon pigeon;
        return releasedEntity instanceof Pigeon && (pigeon = (Pigeon)releasedEntity).isTired() ? (Double)Config.Server.PIGEONHOLE_WASTE_INCREASE_CHANCE_AFTER_DELIVERY.get() : (Double)Config.Server.PIGEONHOLE_WASTE_INCREASE_CHANCE.get();
    }

    @Override
    public void onOccupantsChanged() {
        this.setChanged();
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.occupants.clear();
        List occupants = (List)componentInput.getOrDefault(Envelope.DataComponents.PIGEONS, List.of());
        occupants.forEach(o -> this.getOccupants().add(o.toMutable()));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(Envelope.DataComponents.PIGEONS, (Object)this.getImmutableOccupants());
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove(this.getSerializedOccupantsName());
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadOccupiable(tag, registries);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.saveOccupiable(tag, registries);
    }

    @NotNull
    public Level getLevelOrThrow() {
        return Objects.requireNonNull(this.level);
    }

    @Override
    public void playSound(SoundEvent soundEvent, float volume, float pitch) {
        if (this.level != null) {
            this.level.playSound(null, this.getBlockPos(), soundEvent, SoundSource.BLOCKS, volume, pitch);
        }
    }
}

