/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.block.dispenser;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class PlaceBlockDispenseItemBehavior
extends OptionalDispenseItemBehavior {
    @NotNull
    protected ItemStack execute(BlockSource blockSource, ItemStack stack) {
        this.setSuccess(false);
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Direction direction = (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING);
            BlockPos placePos = blockSource.pos().relative(direction);
            try {
                this.setSuccess(blockItem.place((BlockPlaceContext)new DirectionalPlaceContext((Level)blockSource.level(), placePos, direction, stack, direction)).consumesAction());
            }
            catch (Exception e) {
                LOGGER.error("Error trying to place block at {}", (Object)placePos, (Object)e);
            }
        }
        return stack;
    }
}

