/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.block.dispenser;

import io.github.mortuusars.envelope.world.block.PigeonholeBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class WasteScoopingDispenseItemBehavior
extends OptionalDispenseItemBehavior {
    public static final WasteScoopingDispenseItemBehavior INSTANCE = new WasteScoopingDispenseItemBehavior();

    @NotNull
    protected ItemStack execute(BlockSource blockSource, ItemStack item) {
        ServerLevel level = blockSource.level();
        BlockPos blockPos = blockSource.pos().relative((Direction)blockSource.state().getValue((Property)DispenserBlock.FACING));
        this.setSuccess(this.tryScoopWaste(level, blockPos));
        if (this.isSuccess()) {
            item.hurtAndBreak(1, level, null, i -> {});
        }
        return item;
    }

    protected boolean tryScoopWaste(ServerLevel level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof PigeonholeBlock && (Integer)state.getValue((Property)PigeonholeBlock.WASTE_LEVEL) >= 5) {
            level.playSound(null, pos, (SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
            DispenserBlock.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)((Direction)state.getValue((Property)PigeonholeBlock.FACING)), (ItemStack)new ItemStack((ItemLike)Items.BONE_MEAL));
            level.setBlock(pos, (BlockState)state.setValue((Property)PigeonholeBlock.WASTE_LEVEL, (Comparable)Integer.valueOf(0)), 3);
            return true;
        }
        return false;
    }
}

