/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.block.mailbox;

import com.google.common.base.Preconditions;
import io.github.mortuusars.envelope.world.item.component.Id;
import io.github.mortuusars.envelope.world.item.mail.Mail;
import io.github.mortuusars.envelope.world.mail.address.Address;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface Inbox {
    public Address getAddress();

    public int getInboxCapacity();

    @NotNull
    public List<ItemStack> getAllMail();

    public void onInboxChanged();

    default public boolean isInboxFull() {
        return this.getAllMail().size() >= this.getInboxCapacity();
    }

    default public boolean isInboxEmpty() {
        return this.getAllMail().isEmpty();
    }

    default public ItemStack getMail(int slot) {
        if (slot >= 0 && slot < this.getAllMail().size()) {
            return this.getAllMail().get(slot);
        }
        return ItemStack.EMPTY;
    }

    default public boolean addMailNoUpdate(int slot, ItemStack mail) {
        Preconditions.checkArgument((!mail.isEmpty() ? 1 : 0) != 0, (Object)"Inbox can only store non-empty mail.");
        Preconditions.checkArgument((mail.getCount() == 1 ? 1 : 0) != 0, (Object)("Inbox can only store mail with stack size of 1. Got: " + mail.getCount()));
        Preconditions.checkArgument((boolean)Mail.hasId(mail), (Object)"Inbox can only store mail with 'envelope:mail_id' component.");
        Preconditions.checkArgument((slot >= 0 ? 1 : 0) != 0, (Object)("Slot index should be larger or equal to 0. Got: " + slot));
        int size = this.getAllMail().size();
        if (size < this.getInboxCapacity()) {
            if (slot > size) {
                this.getAllMail().add(mail);
            } else {
                this.getAllMail().add(slot, mail);
            }
            return true;
        }
        return false;
    }

    default public boolean addMailNoUpdate(ItemStack mail) {
        return this.addMailNoUpdate(Integer.MAX_VALUE, mail);
    }

    default public boolean addMail(int slot, ItemStack mail) {
        if (this.addMailNoUpdate(slot, mail)) {
            this.onInboxChanged();
            this.onMailAdded(mail);
            return true;
        }
        return false;
    }

    default public boolean addMail(ItemStack mail) {
        if (this.addMailNoUpdate(mail)) {
            this.onInboxChanged();
            this.onMailAdded(mail);
            return true;
        }
        return false;
    }

    default public ItemStack removeMailNoUpdate(int slot) {
        if (slot >= 0 && slot < this.getAllMail().size()) {
            return this.getAllMail().remove(slot);
        }
        return ItemStack.EMPTY;
    }

    default public ItemStack removeMailNoUpdate() {
        return this.removeMailNoUpdate(0);
    }

    default public ItemStack removeMail(Id id) {
        for (int i = 0; i < this.getAllMail().size(); ++i) {
            ItemStack mail = this.getAllMail().get(i);
            if (!id.equals(Mail.getId(mail))) continue;
            return this.removeMail(i);
        }
        return ItemStack.EMPTY;
    }

    default public ItemStack removeMail(int slot) {
        ItemStack mail = this.removeMailNoUpdate(slot);
        if (!mail.isEmpty()) {
            this.onInboxChanged();
            this.onMailRemoved(slot, mail);
        }
        return mail;
    }

    default public ItemStack removeMail() {
        return this.removeMail(0);
    }

    default public boolean clearMail() {
        if (this.getAllMail().isEmpty()) {
            return false;
        }
        this.getAllMail().clear();
        this.onInboxChanged();
        this.onMailCleared();
        return true;
    }

    default public void onMailInserted(ItemStack mail) {
    }

    default public void onMailAdded(ItemStack mail) {
    }

    default public void onMailRemoved(int slot, ItemStack mail) {
    }

    default public void onMailCleared() {
    }
}

