/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.block.mailbox;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.util.bugger.Bugger;
import io.github.mortuusars.envelope.world.block.mailbox.Inbox;
import io.github.mortuusars.envelope.world.block.mailbox.UnloadedInbox;
import io.github.mortuusars.envelope.world.mail.address.Address;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class InboxStorage
extends SavedData {
    public static final Codec<InboxStorage> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, UnloadedInbox.CODEC).optionalFieldOf("inboxes", Collections.emptyMap()).forGetter(InboxStorage::getInboxes)).apply((Applicative)instance, InboxStorage::new));
    public static final Logger LOGGER = LogUtils.getLogger();
    private final Map<UUID, UnloadedInbox> inboxes;

    public InboxStorage(Map<UUID, UnloadedInbox> inboxes) {
        this.inboxes = new HashMap<UUID, UnloadedInbox>(inboxes);
    }

    public InboxStorage() {
        this.inboxes = new HashMap<UUID, UnloadedInbox>();
    }

    protected Map<UUID, UnloadedInbox> getInboxes() {
        return this.inboxes;
    }

    public void put(UUID id, Inbox inbox) {
        UnloadedInbox unloadedInbox = new UnloadedInbox(id, inbox.getAddress(), inbox.getInboxCapacity(), inbox.getAllMail());
        unloadedInbox.getAllMail().removeIf(ItemStack::isEmpty);
        this.inboxes.put(unloadedInbox.getId(), unloadedInbox);
        this.setDirty();
        if (Bugger.isEnabled() && !unloadedInbox.isInboxEmpty()) {
            LOGGER.info("Stored inbox with size [{}] of mailbox {}", (Object)unloadedInbox.getAllMail().size(), (Object)unloadedInbox.getAddress());
        }
    }

    public Optional<Inbox> remove(UUID id) {
        return Optional.ofNullable(this.inboxes.remove(id)).map(inbox -> {
            this.setDirty();
            if (Bugger.isEnabled() && !inbox.getAllMail().isEmpty()) {
                LOGGER.info("Loaded inbox with size [{}] of mailbox {}", (Object)inbox.getAllMail().size(), (Object)inbox.getAddress());
            }
            return inbox;
        });
    }

    @NotNull
    public Optional<Inbox> getForDelivery(Address.Block address) {
        for (UnloadedInbox inbox : this.getInboxes().values()) {
            if (!inbox.getAddress().equals(address)) continue;
            inbox.onChanged(() -> ((InboxStorage)this).setDirty());
            return Optional.of(inbox);
        }
        return Optional.empty();
    }

    public static InboxStorage get(ServerLevel level) {
        return (InboxStorage)level.getServer().overworld().getDataStorage().computeIfAbsent(InboxStorage.factory(), "envelope_inboxes");
    }

    @NotNull
    public static SavedData.Factory<InboxStorage> factory() {
        return new SavedData.Factory(InboxStorage::new, (tag, provider) -> CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), tag).resultOrPartial(e -> Envelope.LOGGER.error("Cannot load InboxStorage: {}", e)).orElse(null), null);
    }

    @NotNull
    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        return CODEC.encode((Object)this, (DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).resultOrPartial(e -> Envelope.LOGGER.error("Cannot save InboxStorage: {}", e)).orElse(tag);
    }
}

