/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.block.mailbox;

import com.mojang.serialization.MapCodec;
import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.network.Packets;
import io.github.mortuusars.envelope.network.packet.clientbound.OpenMailboxAddressTagScreenS2CP;
import io.github.mortuusars.envelope.world.block.mailbox.MailboxBlockEntity;
import io.github.mortuusars.envelope.world.delivery.CourierOrigin;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import io.github.mortuusars.envelope.world.item.AddressTagItem;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.mail.address.AddressValidation;
import io.github.mortuusars.envelope.world.mail.address.AllAddresses;
import io.github.mortuusars.envelope.world.service.MailService;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MailboxBlock
extends BaseEntityBlock {
    public static final MapCodec<MailboxBlock> CODEC = MailboxBlock.simpleCodec(MailboxBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);

    public MailboxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, OPEN});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        MailboxBlockEntity blockEntity;
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof MailboxBlockEntity && !(blockEntity = (MailboxBlockEntity)blockEntity2).getAllMail().isEmpty()) {
            return 15;
        }
        return 0;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        super.setPlacedBy(level, pos, state, placer, stack);
        if (placer != null && (blockEntity = level.getBlockEntity(pos)) instanceof MailboxBlockEntity) {
            MailboxBlockEntity blockEntity2 = (MailboxBlockEntity)blockEntity;
            blockEntity2.setOwner(placer.getUUID());
        }
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.getBlock().equals(newState.getBlock()) && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MailService.of(serverLevel).getMailboxes().remove(pos);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof MailboxBlockEntity) {
                MailboxBlockEntity blockEntity2 = (MailboxBlockEntity)blockEntity;
                blockEntity2.onBlockRemoved(level, pos, state, newState);
            }
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        MailboxBlockEntity blockEntity;
        Object knownAddresses2;
        if (!MailService.operatesIn(level)) {
            player.displayClientMessage((Component)Component.literal((String)"Mail Service does not operate in this dimension.").withStyle(ChatFormatting.RED), true);
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.getItem() instanceof AddressTagItem) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                BlockEntity blockEntity2 = level.getBlockEntity(pos);
                if (blockEntity2 instanceof MailboxBlockEntity) {
                    MailboxBlockEntity blockEntity3 = (MailboxBlockEntity)blockEntity2;
                    AllAddresses knownAddresses2 = serverPlayer.serverLevel().getEnvelopeMailService().getKnownAddresses();
                    Packets.sendToClient(new OpenMailboxAddressTagScreenS2CP(hand, knownAddresses2, pos, blockEntity3.getAddress()), serverPlayer);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (player.isCreative() && stack.is(Envelope.Tags.Items.MAILABLE) && (knownAddresses2 = stack.get(Envelope.DataComponents.MAIL_RECIPIENT)) instanceof Address.Block) {
            Address.Block recipientAddress = (Address.Block)knownAddresses2;
            knownAddresses2 = level.getBlockEntity(pos);
            if (knownAddresses2 instanceof MailboxBlockEntity && (blockEntity = (MailboxBlockEntity)knownAddresses2).getAddress().equals(recipientAddress)) {
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    ItemStack result = MailService.of(serverLevel).deliverMail(recipientAddress, stack.split(1));
                    if (player.getItemInHand(hand).isEmpty()) {
                        player.setItemInHand(hand, result.copy());
                    } else if (!player.addItem(result)) {
                        player.drop(result, false);
                    }
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        if (stack.is((Item)Envelope.Items.PIGEON_SPAWN_EGG.get())) {
            if (level instanceof ServerLevel) {
                Pigeon pigeon;
                ServerLevel serverLevel = (ServerLevel)level;
                BlockEntity blockEntity4 = level.getBlockEntity(pos);
                if (blockEntity4 instanceof MailboxBlockEntity && (blockEntity = (MailboxBlockEntity)blockEntity4).isAvailableForPickup() && (blockEntity4 = Envelope.EntityTypes.PIGEON.get().spawn(serverLevel, pos.relative((Direction)state.getValue((Property)FACING)), MobSpawnType.SPAWN_EGG)) instanceof Pigeon && blockEntity.tryStartDelivery(pigeon = (Pigeon)blockEntity4)) {
                    pigeon.setOrigin(CourierOrigin.service());
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                } else {
                    serverLevel.playSound(null, pos, (SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!MailService.operatesIn(level)) {
            player.displayClientMessage((Component)Component.literal((String)"Mail Service does not operate in this dimension.").withStyle(ChatFormatting.RED), true);
            return InteractionResult.SUCCESS_NO_ITEM_USED;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MailboxBlockEntity) {
            MailboxBlockEntity blockEntity2 = (MailboxBlockEntity)blockEntity;
            blockEntity2.openMenu(player);
        }
        return InteractionResult.SUCCESS_NO_ITEM_USED;
    }

    public void changeAddress(Player player, BlockPos pos, InteractionHand hand, String addressId) {
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        ItemStack stack = player.getItemInHand(hand);
        if (!(stack.getItem() instanceof AddressTagItem)) {
            Envelope.LOGGER.error("Failed change address: item in hand is not AddressTagItem, but {}", (Object)stack);
            return;
        }
        BlockEntity blockEntity = level2.getBlockEntity(pos);
        if (!(blockEntity instanceof MailboxBlockEntity)) {
            Envelope.LOGGER.error("Failed change address: block entity at pos is not a MailboxBlockEntity.");
            return;
        }
        MailboxBlockEntity blockEntity2 = (MailboxBlockEntity)blockEntity;
        AddressValidation.forMailbox(MailService.of(level2).getKnownAddresses(), player).test(addressId).ifPresentOrElse(id -> {
            MailboxBlock.applyAddress(player, blockEntity2, new Address.Block((String)id), stack);
            player.swing(hand, true);
            if (!player.isCreative()) {
                stack.shrink(1);
            }
        }, error -> {
            player.displayClientMessage((Component)error.getTranslation(), true);
            player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), 0.75f, 1.0f);
        });
    }

    public static void placeBlockWithAddress(Player player, InteractionHand hand, BlockPlaceContext context, String addressId) {
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        BlockPos pos = context.getClickedPos();
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), 0.75f, 1.0f);
            Envelope.LOGGER.error("Failed to place mailbox: item in hand is not a BlockItem, but {}", (Object)stack);
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        AddressValidation.forMailbox(MailService.of(level2).getKnownAddresses(), player).test(addressId).ifPresentOrElse(id -> {
            blockItem.place(context);
            BlockEntity patt0$temp = level2.getBlockEntity(pos);
            if (!(patt0$temp instanceof MailboxBlockEntity)) {
                player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), 0.75f, 1.0f);
                Envelope.LOGGER.error("Failed to place mailbox: be at pos [{}] is not MailboxBlockEntity", (Object)pos.toShortString());
                return;
            }
            MailboxBlockEntity blockEntity = (MailboxBlockEntity)patt0$temp;
            blockEntity.getBlockState().getBlock().setPlacedBy((Level)level2, pos, blockEntity.getBlockState(), (LivingEntity)player, stack);
            MailboxBlock.applyAddress(player, blockEntity, new Address.Block((String)id), stack);
            player.swing(hand, true);
        }, error -> {
            player.displayClientMessage((Component)error.getTranslation(), true);
            player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), 0.75f, 1.0f);
        });
    }

    private static void applyAddress(Player player, MailboxBlockEntity blockEntity, Address.Block address, ItemStack stack) {
        blockEntity.setAddress(address);
        if ((Integer)Config.Server.MAILBOX_ADDRESS_EXPERIENCE_LEVELS_COST.get() > 0) {
            player.level().playSound(player, blockEntity.getBlockPos(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS);
        }
        if (!player.isCreative()) {
            player.giveExperienceLevels(-((Integer)Config.Server.MAILBOX_ADDRESS_EXPERIENCE_LEVELS_COST.get()).intValue());
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new MailboxBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : MailboxBlock.createTickerHelper(blockEntityType, Envelope.BlockEntityTypes.MAILBOX.get(), (lvl, blockPos, blockState, blockEntity) -> blockEntity.serverTick((ServerLevel)lvl, blockPos, state));
    }
}

