/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.block.mailbox;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.PlatformHelper;
import io.github.mortuusars.envelope.network.Packets;
import io.github.mortuusars.envelope.network.packet.clientbound.MailboxHasNewMailS2CP;
import io.github.mortuusars.envelope.world.block.mailbox.Inbox;
import io.github.mortuusars.envelope.world.block.mailbox.InboxStorage;
import io.github.mortuusars.envelope.world.block.mailbox.MailboxBlock;
import io.github.mortuusars.envelope.world.delivery.Delivery;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import io.github.mortuusars.envelope.world.inventory.MailboxMenu;
import io.github.mortuusars.envelope.world.item.component.Id;
import io.github.mortuusars.envelope.world.item.mail.Mail;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.mail.address.SimpleBlockAddressGenerator;
import io.github.mortuusars.envelope.world.service.MailService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class MailboxBlockEntity
extends BaseContainerBlockEntity
implements Inbox {
    public static final int REGULAR_SLOTS = 2;
    public static final int SLOT_FOOD = 0;
    public static final int SLOT_MAIL = 1;
    public static final int INBOX_SLOT = 2;
    private static final Logger LOGGER = LogUtils.getLogger();
    private NonNullList<ItemStack> items = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    @NotNull
    private UUID inboxId = UUID.randomUUID();
    @Nullable
    private Address.Block address;
    @Nullable
    private UUID owner;
    @NotNull
    private List<ItemStack> mail = new ArrayList<ItemStack>();
    private boolean loaded = false;
    private boolean blockRemoved = false;

    protected MailboxBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public MailboxBlockEntity(BlockPos pos, BlockState blockState) {
        this(Envelope.BlockEntityTypes.MAILBOX.get(), pos, blockState);
    }

    @NotNull
    protected Component getDefaultName() {
        return this.address != null ? this.address.getName() : Component.translatable((String)"container.envelope.mailbox");
    }

    @Override
    @NotNull
    public Address.Block getAddress() {
        return (Address.Block)Preconditions.checkNotNull((Object)this.address, (Object)("Address of mailbox at [" + this.getBlockPos().toShortString() + "] was not set."));
    }

    public void setAddress(@Nullable Address.Block address) {
        ServerLevel serverLevel;
         @Nullable Address.Block currentAddress = this.address;
        this.address = address;
        Level level = this.getLevel();
        if (level instanceof ServerLevel && MailService.operatesIn((Level)(serverLevel = (ServerLevel)level))) {
            address = Objects.requireNonNullElseGet(address, () -> this.generateRandomAddress(serverLevel));
            address = MailService.of(serverLevel).getMailboxes().correctOrRegisterIfNeeded(address, this.getBlockPos());
            if (!address.equals(currentAddress)) {
                this.address = address;
                this.setChanged();
                serverLevel.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }

    protected void applyAddress() {
        this.setAddress(this.address);
    }

    @NotNull
    protected Address.Block generateRandomAddress(ServerLevel level) {
        return new SimpleBlockAddressGenerator(MailService.of(level).getKnownAddresses(), 50).generate(level.getRandom());
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable UUID owner) {
        this.owner = owner;
        this.setChanged();
    }

    public Optional<Player> getOwnerPlayer() {
        if (this.owner == null || this.level == null) {
            return Optional.empty();
        }
        for (Player player : this.level.players()) {
            if (!player.getUUID().equals(this.owner)) continue;
            return Optional.of(player);
        }
        return Optional.empty();
    }

    @NotNull
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    public int getContainerSize() {
        return 2 + this.getAllMail().size();
    }

    @NotNull
    public ItemStack getItem(int slot) {
        if (slot >= 2) {
            return this.getMail(slot - 2);
        }
        return super.getItem(slot);
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        if (slot >= 2) {
            return this.removeMail(slot - 2);
        }
        return super.removeItem(slot, amount);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        if (slot >= 2) {
            return this.removeMailNoUpdate(slot - 2);
        }
        return super.removeItemNoUpdate(slot);
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot >= 2) {
            this.addMail(slot - 2, stack);
            return;
        }
        super.setItem(slot, stack);
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (slot == 0) {
            return stack.is(Envelope.Tags.Items.PIGEON_FOOD);
        }
        if (slot == 1) {
            return this.isSendable(stack);
        }
        return false;
    }

    public boolean canTakeItem(Container target, int slot, ItemStack stack) {
        return slot >= 2 && target.hasAnyMatching(ItemStack::isEmpty);
    }

    public boolean isSendable(ItemStack stack) {
        return !stack.isEmpty() && stack.is(Envelope.Tags.Items.MAILABLE) && stack.has(Envelope.DataComponents.MAIL_RECIPIENT);
    }

    public boolean isAvailableForPickup() {
        if (this.level == null) {
            return false;
        }
        return !this.getItem(0).isEmpty() && this.isSendable(this.getItem(1));
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        this.applyAddress();
        return new MailboxMenu(containerId, inventory, this.getBlockPos(), this.getAddress(), this.getAllMail());
    }

    public void openMenu(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.getOwner() == null) {
                this.setOwner(player.getUUID());
            }
            PlatformHelper.openMenu(serverPlayer, (MenuProvider)this, buffer -> {
                buffer.writeBlockPos(this.getBlockPos());
                Address.Block.STREAM_CODEC.encode(buffer, (Object)this.getAddress());
                ItemStack.LIST_STREAM_CODEC.encode(buffer, this.getAllMail());
            });
            this.playSound(SoundEvents.BARREL_OPEN, 0.6f, 1.1f);
        }
    }

    public boolean tryStartDelivery(Pigeon pigeon) {
        if (!MailService.operatesIn(pigeon.level())) {
            return false;
        }
        ServerLevel level = (ServerLevel)pigeon.level();
        if (pigeon.isDelivering()) {
            return false;
        }
        ItemStack mailStack = this.getItem(1);
        if (!this.isSendable(mailStack)) {
            return false;
        }
        this.applyAddress();
        ItemStack mail = Mail.removePreviousDeliveryData(mailStack.copyWithCount(1));
        return MailService.of(level).getDeliveryManager().start(pigeon, Delivery.draft().deliver(mail).from(this.getAddress()).to(Mail.getRecipientOrUnknown(mail)).owner(this.getOwner())).getValue().map(delivery -> {
            this.removeItem(1, 1);
            this.removeItem(0, 1);
            Vec3 pos = pigeon.position();
            level.sendParticles((ParticleOptions)ParticleTypes.CLOUD, pos.x, pos.y, pos.z, 10, 0.3, 0.3, 0.3, 0.02);
            level.playSound(null, pos.x, pos.y, pos.z, SoundEvents.ARMOR_EQUIP_LEATHER, SoundSource.NEUTRAL, 1.0f, 1.3f);
            return true;
        }).orElse(false);
    }

    @Override
    public int getInboxCapacity() {
        return 512;
    }

    @Override
    @NotNull
    public List<ItemStack> getAllMail() {
        return this.mail;
    }

    @Override
    public void onMailInserted(ItemStack mail) {
        this.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_CHIME.value(), 1.0f, 1.0f);
    }

    @Override
    public void onMailAdded(ItemStack mail) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MailboxMenu.playersWithMenu(serverLevel, this.getAddress()).forEach(player -> Packets.sendToClient(MailboxHasNewMailS2CP.INSTANCE, player));
        }
    }

    @Override
    public void onMailRemoved(int slot, ItemStack mail) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Optional.ofNullable(Mail.getId(mail)).ifPresent(id -> MailboxMenu.executeForPlayersWithMenu(serverLevel, this.getAddress(), (player, menu) -> menu.onMailRemoved((Id)id)));
        }
    }

    @Override
    public void onInboxChanged() {
        if (this.level != null) {
            this.level.updateNeighbourForOutputSignal(this.getBlockPos(), this.getBlockState().getBlock());
        }
    }

    protected void loadInbox() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.mail = InboxStorage.get(serverLevel).remove(this.inboxId).map(Inbox::getAllMail).orElseGet(ArrayList::new);
        } else {
            this.mail = new ArrayList<ItemStack>();
        }
    }

    protected void unloadInbox() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.address != null) {
                InboxStorage.get(serverLevel).put(this.inboxId, this);
            }
        }
        this.mail.clear();
    }

    public void serverTick(ServerLevel level, BlockPos blockPos, BlockState blockState) {
        if (!this.loaded) {
            this.onLoaded();
            this.loaded = true;
        }
    }

    protected void onLoaded() {
        this.applyAddress();
        if (this.level != null) {
            this.level.updateNeighbourForOutputSignal(this.getBlockPos(), this.getBlockState().getBlock());
        }
    }

    public void onBlockRemoved(Level level, BlockPos pos, BlockState state, BlockState newState) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)level, (BlockPos)pos);
        this.clearMail();
        this.blockRemoved = true;
    }

    public void clearRemoved() {
        super.clearRemoved();
        this.loadInbox();
        this.blockRemoved = false;
    }

    public void setRemoved() {
        super.setRemoved();
        if (!this.blockRemoved) {
            this.unloadInbox();
        }
    }

    public void setChanged() {
        super.setChanged();
        this.updateBlockStateIfNeeded();
    }

    private void updateBlockStateIfNeeded() {
        Level level;
        if (!this.isRemoved() && (level = this.level) instanceof ServerLevel) {
            boolean shouldBeOpen;
            ServerLevel serverLevel = (ServerLevel)level;
            BlockState state = this.getBlockState();
            boolean isOpen = (Boolean)state.getValue((Property)MailboxBlock.OPEN);
            if (isOpen != (shouldBeOpen = this.isAvailableForPickup())) {
                serverLevel.setBlockAndUpdate(this.getBlockPos(), (BlockState)state.setValue((Property)MailboxBlock.OPEN, (Comparable)Boolean.valueOf(shouldBeOpen)));
                this.playSound(shouldBeOpen ? SoundEvents.CHERRY_WOOD_TRAPDOOR_OPEN : SoundEvents.CHERRY_WOOD_TRAPDOOR_CLOSE, 0.75f, shouldBeOpen ? 1.0f : 0.75f);
            }
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveCustomOnly(registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        this.setAddress(tag.contains("address", 8) ? new Address.Block(tag.getString("address")) : null);
        this.owner = tag.hasUUID("owner") ? tag.getUUID("owner") : null;
        this.inboxId = tag.hasUUID("inbox_id") ? tag.getUUID("inbox_id") : UUID.randomUUID();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        if (this.address != null) {
            tag.putString("address", this.address.id());
        }
        if (this.owner != null) {
            tag.putUUID("owner", this.owner);
        }
        tag.putUUID("inbox_id", this.inboxId);
    }

    public void playSound(SoundEvent soundEvent, float volume, float pitch) {
        if (this.level != null) {
            this.level.playSound(null, this.getBlockPos(), soundEvent, SoundSource.BLOCKS, volume, pitch);
        }
    }
}

