/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.block.mailbox;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.block.mailbox.MailboxBlockEntity;
import io.github.mortuusars.envelope.world.block.mailbox.MailboxesSavedData;
import io.github.mortuusars.envelope.world.block.mailbox.RegisteredMailbox;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.mail.address.AddressUniquifier;
import io.github.mortuusars.envelope.world.mail.address.AllAddresses;
import io.github.mortuusars.envelope.world.service.MailService;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class Mailboxes {
    protected static final Logger LOGGER = LogUtils.getLogger();
    private final ServerLevel level;
    @Nullable
    private MailboxesSavedData data;

    public Mailboxes(ServerLevel level) {
        this.level = level;
    }

    @NotNull
    protected MailboxesSavedData data() {
        if (this.data == null) {
            this.data = MailboxesSavedData.get(this.level);
        }
        return this.data;
    }

    protected Map<Address.Block, RegisteredMailbox> getMailboxes() {
        return this.data().getMailboxes();
    }

    protected void setDirty() {
        this.data().setDirty();
    }

    public Set<Address.Block> getAllAddresses() {
        return this.getMailboxes().keySet();
    }

    @NotNull
    public Address.Block correctOrRegisterIfNeeded(Address.Block suggestedAddress, BlockPos pos) {
        @Nullable RegisteredMailbox registeredAtPos = this.getAtPosition(pos);
        if (registeredAtPos != null) {
            if (registeredAtPos.getAddress().equals(suggestedAddress) && !this.inUseAsPlayerOrEntity(registeredAtPos.getAddress())) {
                return suggestedAddress;
            }
            return this.rename(registeredAtPos, suggestedAddress).getAddress();
        }
        Address.Block address = this.uniquifyIfKnown(suggestedAddress);
        this.getMailboxes().entrySet().removeIf(entry -> {
            if (((RegisteredMailbox)entry.getValue()).getPos().equals((Object)pos)) {
                LOGGER.info("Removing mailbox '{}'@[{}] because new mailbox '{}' is being registered at the same blockpos.", new Object[]{((RegisteredMailbox)entry.getValue()).getAddress().id(), ((RegisteredMailbox)entry.getValue()).getPos().toShortString(), address.id()});
                return true;
            }
            return false;
        });
        RegisteredMailbox data = new RegisteredMailbox(address, pos);
        this.getMailboxes().put(address, data);
        if (Envelope.debug()) {
            LOGGER.info("Registered new mailbox '{}'@[{}]", (Object)address.id(), (Object)pos.toShortString());
        }
        this.setDirty();
        return address;
    }

    public void remove(Address.Block address) {
        @Nullable RegisteredMailbox removed = this.getMailboxes().remove(address);
        if (removed != null) {
            MailService.of(this.level).getPlayers().removeDefaultAddress(address);
            this.setDirty();
            if (Envelope.debug()) {
                LOGGER.info("Removed mailbox '{}'@[{}]", (Object)removed.getAddress().id(), (Object)removed.getPos().toShortString());
            }
        }
    }

    public void remove(BlockPos pos) {
        Optional.ofNullable(this.getAtPosition(pos)).ifPresent(data -> this.remove(data.getAddress()));
    }

    @NotNull
    public RegisteredMailbox rename(RegisteredMailbox data, Address.Block suggestedAddress) {
        Address.Block newAddress = this.uniquifyIfKnown(suggestedAddress);
        MailService.of(this.level).getPlayers().renameDefaultAddress(data.getAddress(), newAddress);
        RegisteredMailbox newData = new RegisteredMailbox(newAddress, data.getPos());
        this.getMailboxes().remove(data.getAddress());
        this.getMailboxes().put(newAddress, newData);
        if (Envelope.debug()) {
            LOGGER.info("Renamed mailbox '{}'@[{}] to '{}'", new Object[]{data.getAddress().id(), data.getPos().toShortString(), newAddress.id()});
        }
        this.setDirty();
        return newData;
    }

    public void rename(Address.Block oldAddress, Address.Block suggestedAddress) {
        this.getByAddress(oldAddress).ifPresent(data -> this.rename((RegisteredMailbox)data, suggestedAddress));
    }

    public boolean exists(Address.Block block) {
        return this.getMailboxes().containsKey(block);
    }

    public Optional<RegisteredMailbox> getByAddress(Address.Block address) {
        return Optional.ofNullable(this.getMailboxes().get(address));
    }

    @Nullable
    public RegisteredMailbox getAtPosition(BlockPos pos) {
        for (RegisteredMailbox mailbox : this.getMailboxes().values()) {
            if (!mailbox.getPos().equals((Object)pos)) continue;
            return mailbox;
        }
        return null;
    }

    public Optional<BlockPos> getPositionOf(Address.Block address) {
        return this.getByAddress(address).map(RegisteredMailbox::getPos);
    }

    public Optional<MailboxBlockEntity> getBlockEntityOf(Address.Block address) {
        return this.getPositionOf(address).flatMap(pos -> {
            Optional<Object> optional;
            BlockEntity patt0$temp;
            if (this.level.isLoaded(pos) && (patt0$temp = this.level.getBlockEntity(pos)) instanceof MailboxBlockEntity) {
                MailboxBlockEntity blockEntity = (MailboxBlockEntity)patt0$temp;
                optional = Optional.of(blockEntity);
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
    }

    private boolean inUseAsPlayerOrEntity(Address.Block address) {
        AllAddresses knownAddresses = MailService.of(this.level).getKnownAddresses();
        return knownAddresses.isKnownOfType(address, Address.Type.PLAYER) || knownAddresses.isKnownOfType(address, Address.Type.ENTITY);
    }

    private Address.Block uniquifyIfKnown(Address.Block address) {
        AllAddresses knownAddresses = MailService.of(this.level).getKnownAddresses();
        if (!knownAddresses.isKnown(address)) {
            return address;
        }
        AddressUniquifier uniquifier = new AddressUniquifier(knownAddresses);
        String uniqueId = uniquifier.uniquify(address.id());
        return new Address.Block(uniqueId);
    }
}

