/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.block.mailbox;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.block.mailbox.RegisteredMailbox;
import io.github.mortuusars.envelope.world.mail.address.Address;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class MailboxesSavedData
extends SavedData {
    public static final Codec<MailboxesSavedData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap(Address.Block.STRING_CODEC, RegisteredMailbox.CODEC).optionalFieldOf("mailboxes", Collections.emptyMap()).forGetter(MailboxesSavedData::getMailboxes)).apply((Applicative)instance, MailboxesSavedData::new));
    private final HashMap<Address.Block, RegisteredMailbox> mailboxes;

    protected MailboxesSavedData(Map<Address.Block, RegisteredMailbox> mailboxes) {
        this.mailboxes = new HashMap<Address.Block, RegisteredMailbox>(mailboxes);
    }

    protected MailboxesSavedData() {
        this(new HashMap<Address.Block, RegisteredMailbox>());
    }

    public HashMap<Address.Block, RegisteredMailbox> getMailboxes() {
        return this.mailboxes;
    }

    public static MailboxesSavedData get(ServerLevel level) {
        return (MailboxesSavedData)level.getDataStorage().computeIfAbsent(MailboxesSavedData.factory(), "envelope_mailboxes");
    }

    @NotNull
    public static SavedData.Factory<MailboxesSavedData> factory() {
        return new SavedData.Factory(MailboxesSavedData::new, (tag, provider) -> CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), tag).resultOrPartial(e -> Envelope.LOGGER.error("Cannot load MailboxesSavedData: {}", e)).orElse(null), null);
    }

    @NotNull
    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        return CODEC.encode((Object)this, (DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).resultOrPartial(e -> Envelope.LOGGER.error("Cannot save MailboxesSavedData: {}", e)).orElse(tag);
    }
}

