/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.block.mailbox;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.envelope.world.block.mailbox.Inbox;
import io.github.mortuusars.envelope.world.mail.address.Address;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class UnloadedInbox
implements Inbox {
    public static final Codec<UnloadedInbox> CODEC = RecordCodecBuilder.create(i -> i.group((App)UUIDUtil.STRING_CODEC.fieldOf("id").forGetter(UnloadedInbox::getId), (App)Address.CODEC.fieldOf("address").forGetter(UnloadedInbox::getAddress), (App)Codec.INT.optionalFieldOf("capacity", (Object)512).forGetter(UnloadedInbox::getInboxCapacity), (App)ItemStack.CODEC.listOf().optionalFieldOf("mail", Collections.emptyList()).forGetter(UnloadedInbox::getAllMail)).apply((Applicative)i, UnloadedInbox::new));
    public static final Logger LOGGER = LogUtils.getLogger();
    private final UUID id;
    private final Address address;
    private final int capacity;
    private final List<ItemStack> mail;
    @Nullable
    private Runnable onChanged;

    public UnloadedInbox(UUID id, Address address, int capacity, List<ItemStack> mail) {
        this.id = id;
        this.address = address;
        this.capacity = capacity;
        this.mail = new ArrayList<ItemStack>(mail);
    }

    public UUID getId() {
        return this.id;
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public int getInboxCapacity() {
        return this.capacity;
    }

    @Override
    @NotNull
    public List<ItemStack> getAllMail() {
        return this.mail;
    }

    public void onChanged(@NotNull Runnable onChanged) {
        this.onChanged = onChanged;
    }

    @Override
    public void onInboxChanged() {
        if (this.onChanged == null) {
            LOGGER.warn("UnloadedInbox was changed without onChanged callback being set. Changes may not persist.");
        } else {
            this.onChanged.run();
        }
    }
}

