/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.block.occupiable;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.component.CustomData;

public record Occupant(CustomData entityData, int slot, int minTicksInside, int ticksInside) {
    public static final Codec<Occupant> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CustomData.CODEC.optionalFieldOf("entity_data", (Object)CustomData.EMPTY).forGetter(Occupant::entityData), (App)Codec.INT.fieldOf("slot").forGetter(Occupant::slot), (App)Codec.INT.fieldOf("min_ticks_inside").forGetter(Occupant::minTicksInside), (App)Codec.INT.optionalFieldOf("ticks_inside", (Object)0).forGetter(Occupant::ticksInside)).apply((Applicative)instance, Occupant::new));
    public static final Codec<List<Occupant>> LIST_CODEC = CODEC.listOf();
    public static final StreamCodec<ByteBuf, Occupant> STREAM_CODEC = StreamCodec.composite((StreamCodec)CustomData.STREAM_CODEC, Occupant::entityData, (StreamCodec)ByteBufCodecs.VAR_INT, Occupant::slot, (StreamCodec)ByteBufCodecs.VAR_INT, Occupant::minTicksInside, (StreamCodec)ByteBufCodecs.VAR_INT, Occupant::ticksInside, Occupant::new);

    public Mutable toMutable() {
        return new Mutable(this);
    }

    public static class Mutable {
        protected final Occupant occupant;
        protected int ticksInside;

        public Mutable(Occupant occupant) {
            this.occupant = occupant;
            this.ticksInside = occupant.ticksInside();
        }

        public Occupant getOccupant() {
            return this.occupant;
        }

        public int getTicksInside() {
            return this.ticksInside;
        }

        public boolean tick() {
            return this.ticksInside++ >= this.occupant.minTicksInside();
        }

        public Occupant toImmutable() {
            return new Occupant(this.occupant.entityData(), this.occupant.slot(), this.occupant.minTicksInside(), this.getTicksInside());
        }
    }
}

