/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.block.occupiable;

import com.mojang.serialization.DynamicOps;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.block.occupiable.Occupant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public interface Occupiable {
    public static final List<String> IGNORED_OCCUPANT_TAGS = Arrays.asList("Air", "ArmorDropChances", "ArmorItems", "Brain", "CanPickUpLoot", "DeathTime", "FallDistance", "FallFlying", "Fire", "HandDropChances", "HandItems", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "NoGravity", "OnGround", "PortalCooldown", "Pos", "Rotation", "SleepingX", "SleepingY", "SleepingZ", "Passengers", "UUID", "leash");

    public boolean canBeOccupiedBy(Entity var1);

    public List<Occupant.Mutable> getOccupants();

    public SoundEvent getOccupantEnterSound(Entity var1);

    public SoundEvent getOccupantExitSound(Entity var1);

    public SoundEvent getOccupantWorkSound();

    public void playSound(SoundEvent var1, float var2, float var3);

    default public List<Occupant> getImmutableOccupants() {
        return this.getOccupants().stream().map(Occupant.Mutable::toImmutable).toList();
    }

    default public int getMaxOccupantsCount() {
        return 3;
    }

    default public boolean hasSpaceForAnotherOccupant() {
        return this.getOccupants().size() < this.getMaxOccupantsCount();
    }

    default public int getMinimumTicksInsideForOccupant(Entity entity) {
        return 600;
    }

    default public void addOccupant(BlockPos pos, BlockState state, Entity entity) {
        if (!this.hasSpaceForAnotherOccupant() || !this.canBeOccupiedBy(entity)) {
            return;
        }
        entity.stopRiding();
        entity.ejectPassengers();
        CompoundTag tag = new CompoundTag();
        entity.save(tag);
        this.cleanupOccupantEntityTag(tag);
        this.getOccupants().add(new Occupant(CustomData.of((CompoundTag)tag), this.getFirstFreeSlotForOccupant(), this.getMinimumTicksInsideForOccupant(entity), 0).toMutable());
        entity.level().gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)state));
        this.playSound(this.getOccupantEnterSound(entity), 1.0f, 1.0f);
        entity.discard();
        this.onOccupantsChanged();
    }

    default public Optional<Entity> releaseOccupant(Level level, BlockPos pos, BlockState state, Occupant occupant, ReleaseReason reason) {
        boolean isFrontBlockedOff;
        if (!(level instanceof ServerLevel)) {
            return Optional.empty();
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if ((level.isNight() || level.isThundering()) && reason != ReleaseReason.EMERGENCY) {
            return Optional.empty();
        }
        Direction direction = (Direction)state.getValue((Property)BeehiveBlock.FACING);
        BlockPos releasePos = pos.relative(direction);
        boolean bl = isFrontBlockedOff = !level.getBlockState(releasePos).getCollisionShape((BlockGetter)level, releasePos).isEmpty();
        if (isFrontBlockedOff && reason != ReleaseReason.EMERGENCY) {
            return Optional.empty();
        }
        @Nullable Entity entity = this.createEntityFromOccupant(level, occupant, pos);
        if (entity == null) {
            return Optional.empty();
        }
        double offset = isFrontBlockedOff ? 0.0 : 0.55 + (double)(entity.getBbWidth() / 2.0f);
        double x = (double)pos.getX() + 0.5 + offset * (double)direction.getStepX();
        double y = (double)pos.getY() + 0.5 - (double)(entity.getBbHeight() / 2.0f);
        double z = (double)pos.getZ() + 0.5 + offset * (double)direction.getStepZ();
        entity.moveTo(x, y, z, entity.getYRot(), entity.getXRot());
        this.playSound(this.getOccupantExitSound(entity), 1.0f, 1.0f);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)state));
        if (level.addFreshEntity(entity)) {
            this.onOccupantReleased((Level)serverLevel, entity, reason);
            return Optional.of(entity);
        }
        return Optional.empty();
    }

    @Nullable
    default public Entity createEntityFromOccupant(Level level, Occupant occupant, BlockPos pos) {
        CompoundTag tag = occupant.entityData().copyTag();
        this.cleanupOccupantEntityTag(tag);
        @Nullable Entity entity = EntityType.loadEntityRecursive((CompoundTag)tag, (Level)level, Function.identity());
        if (entity == null || !this.canBeOccupiedBy(entity)) {
            return null;
        }
        this.updateEntityAfterRelease(entity, occupant.ticksInside());
        return entity;
    }

    default public List<Entity> releaseAllOccupants(Level level, BlockPos pos, BlockState state, ReleaseReason reason) {
        ArrayList<Entity> releasedEntities = new ArrayList<Entity>();
        this.getOccupants().removeIf(occupant -> this.releaseOccupant(level, pos, state, occupant.toImmutable(), reason).map(entity -> {
            releasedEntities.add((Entity)entity);
            return true;
        }).orElse(false));
        if (!releasedEntities.isEmpty()) {
            this.onOccupantsChanged();
        }
        return releasedEntities;
    }

    default public void onOccupantReleased(Level level, Entity entity, ReleaseReason reason) {
    }

    default public void updateEntityAfterRelease(Entity entity, int ticksInside) {
        entity.setNoGravity(true);
        if (entity instanceof Animal) {
            Animal animal = (Animal)entity;
            int ageTicks = animal.getAge();
            if (ageTicks < 0) {
                animal.setAge(Math.min(0, ageTicks + ticksInside));
            } else if (ageTicks > 0) {
                animal.setAge(Math.max(0, ageTicks - ticksInside));
            }
            animal.setInLoveTime(Math.max(0, animal.getInLoveTime() - ticksInside));
        }
    }

    default public void onOccupantsChanged() {
    }

    default public void tickOccupants(Level level, BlockPos pos, BlockState state) {
        if (!this.getOccupants().isEmpty() && (level.getGameTime() + (long)pos.hashCode()) % 20L == 0L && CampfireBlock.isSmokeyPos((Level)level, (BlockPos)pos)) {
            this.releaseAllOccupants(level, pos, state, ReleaseReason.EMERGENCY);
        }
        if (this.getOccupants().removeIf(occupant -> occupant.tick() && this.releaseOccupant(level, pos, state, occupant.toImmutable(), ReleaseReason.DEFAULT).isPresent())) {
            this.onOccupantsChanged();
        }
        if (!this.getOccupants().isEmpty() && level.getRandom().nextDouble() < 0.004 * (double)this.getOccupants().size()) {
            this.playSound(this.getOccupantWorkSound(), 0.5f, 1.0f);
        }
    }

    default public void cleanupOccupantEntityTag(CompoundTag tag) {
        IGNORED_OCCUPANT_TAGS.forEach(arg_0 -> ((CompoundTag)tag).remove(arg_0));
    }

    default public String getSerializedOccupantsName() {
        return "occupants";
    }

    default public void saveOccupiable(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put(this.getSerializedOccupantsName(), (Tag)Occupant.LIST_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.getImmutableOccupants()).getOrThrow());
    }

    default public void loadOccupiable(CompoundTag tag, HolderLookup.Provider registries) {
        this.getOccupants().clear();
        Occupant.LIST_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(this.getSerializedOccupantsName())).resultOrPartial(error -> Envelope.LOGGER.error("Failed to parse occupants: '{}'", error)).map(list -> list.stream().map(Occupant::toMutable).toList()).ifPresent(list -> this.getOccupants().addAll((Collection<Occupant.Mutable>)list));
    }

    default public int getFirstFreeSlotForOccupant() {
        List<Integer> slots = this.getImmutableOccupants().stream().map(Occupant::slot).sorted().toList();
        int slot = 0;
        while (slots.contains(slot)) {
            ++slot;
        }
        return slot;
    }

    public static enum ReleaseReason {
        DEFAULT,
        EMERGENCY;

    }
}

