/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.block.occupiable;

import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.block.occupiable.Occupiable;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;

public interface PigeonOccupiable
extends Occupiable {
    @Override
    default public boolean canBeOccupiedBy(Entity entity) {
        return entity.getType().is(Envelope.Tags.EntityTypes.PIGEONHOLE_INHABITORS);
    }

    @Override
    default public SoundEvent getOccupantEnterSound(Entity entity) {
        return SoundEvents.BEEHIVE_ENTER;
    }

    @Override
    default public SoundEvent getOccupantExitSound(Entity entity) {
        return SoundEvents.BEEHIVE_EXIT;
    }

    @Override
    default public SoundEvent getOccupantWorkSound() {
        return Envelope.SoundEvents.PIGEON_AMBIENT.get();
    }

    @Override
    default public int getMinimumTicksInsideForOccupant(Entity entity) {
        return (Integer)Config.Server.PIGEON_MIN_TICKS_INSIDE_PIGEONHOLE.get();
    }

    @Override
    default public String getSerializedOccupantsName() {
        return "pigeons";
    }

    @Override
    default public void cleanupOccupantEntityTag(CompoundTag tag) {
        Pigeon.IGNORED_TAGS.forEach(arg_0 -> ((CompoundTag)tag).remove(arg_0));
    }
}

