/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.delivery;

import io.github.mortuusars.envelope.world.delivery.phase.DeliveryPhase;
import io.github.mortuusars.envelope.world.item.component.Id;
import io.github.mortuusars.envelope.world.mail.address.Address;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeliveryDraft {
    @Nullable
    private Id id = null;
    @Nullable
    private UUID owner = null;
    private Address sender = Address.UNKNOWN;
    private Address recipient = Address.UNKNOWN;
    private ItemStack mail = ItemStack.EMPTY;
    private DeliveryPhase phase = DeliveryPhase.STARTED;

    public DeliveryDraft deliver(ItemStack mail) {
        this.mail = mail;
        return this;
    }

    public DeliveryDraft from(Address sender) {
        this.sender = sender;
        return this;
    }

    public DeliveryDraft to(Address recipient) {
        this.recipient = recipient;
        return this;
    }

    public DeliveryDraft owner(@Nullable UUID owner) {
        this.owner = owner;
        return this;
    }

    public DeliveryDraft id(@Nullable Id id) {
        this.id = id;
        return this;
    }

    public DeliveryDraft owner(Player player) {
        this.owner = player.getUUID();
        return this;
    }

    public DeliveryDraft startAtPhase(DeliveryPhase phase) {
        this.phase = phase;
        return this;
    }

    @NotNull
    public Id getOrCreateId(Level level) {
        return this.id != null ? this.id : Id.create(level);
    }

    public Optional<UUID> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    public Address getRecipient() {
        return this.recipient;
    }

    public Address getSender() {
        return this.sender;
    }

    public ItemStack getMail() {
        return this.mail;
    }

    public DeliveryPhase getPhase() {
        return this.phase;
    }

    public String toString() {
        return "DeliveryDraft{owner=" + String.valueOf(this.owner) + ", sender=" + String.valueOf(this.sender) + ", recipient=" + String.valueOf(this.recipient) + ", mail=" + String.valueOf(this.mail) + ", phase=" + String.valueOf((Object)this.phase) + "}";
    }
}

