/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.delivery;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.util.bugger.Bugger;
import io.github.mortuusars.envelope.world.delivery.CourierOrigin;
import io.github.mortuusars.envelope.world.delivery.Delivery;
import io.github.mortuusars.envelope.world.delivery.phase.DeliveryPhase;
import io.github.mortuusars.envelope.world.item.component.mail.log.DeliveryRecord;
import io.github.mortuusars.envelope.world.item.mail.Mail;
import io.github.mortuusars.envelope.world.service.MailService;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;

public interface DeliveryHandler {
    public CourierOrigin getOrigin();

    default public void tickDelivery(ServerLevel level, Delivery delivery) {
        if (delivery.isEnded()) {
            return;
        }
        if (delivery.getPhaseProgress() == 0) {
            this.phaseStarted(level, delivery);
        }
        delivery.incrementCurrentPhaseProgress();
        this.phaseTicked(level, delivery);
        if (delivery.getPhaseProgress() >= this.getPhaseDuration(level, delivery, delivery.getPhase())) {
            this.phaseCompleted(level, delivery);
            if (delivery.getPhase() == DeliveryPhase.FINISHED) {
                Preconditions.checkState((!delivery.isEnded() ? 1 : 0) != 0, (Object)"Delivery is already ended.");
                delivery.end();
                this.endDelivery(level, delivery);
                if (Bugger.isEnabled()) {
                    String type = this.getOrigin().isService() ? "Service delivery" : "Delivery";
                    Envelope.LOGGER.info("{} '{} > {}' is finished.", new Object[]{type, delivery.getSender(), delivery.getRecipient()});
                }
            } else if (!this.handlePhaseTransition(level, delivery)) {
                delivery.setPhaseAndResetProgress(delivery.getPhase().next());
            }
        }
    }

    default public boolean handlePhaseTransition(ServerLevel level, Delivery delivery) {
        if (delivery.getPhase() == DeliveryPhase.DISPATCHING_DELIVERY) {
            return this.dispatchDelivery(level, delivery);
        }
        if (delivery.getPhase() == DeliveryPhase.DISPATCHING_RETURN) {
            return this.dispatchReturn(level, delivery);
        }
        return false;
    }

    default public int getPhaseDuration(ServerLevel level, Delivery delivery, DeliveryPhase phase) {
        return switch (phase) {
            default -> throw new MatchException(null, null);
            case DeliveryPhase.STARTED, DeliveryPhase.FINISHED -> 8;
            case DeliveryPhase.DEPARTING_SENDER, DeliveryPhase.APPROACHING_RECIPIENT, DeliveryPhase.DEPARTING_RECIPIENT, DeliveryPhase.APPROACHING_SENDER -> 100;
            case DeliveryPhase.TRAVELING_FROM_SENDER_TO_HUB, DeliveryPhase.TRAVELING_FROM_HUB_TO_SENDER -> delivery.getRoute().getSenderToHubDuration().ticks();
            case DeliveryPhase.TRAVELING_FROM_HUB_TO_RECIPIENT, DeliveryPhase.TRAVELING_FROM_RECIPIENT_TO_HUB -> delivery.getRoute().getRecipientToHubDuration().ticks();
            case DeliveryPhase.DISPATCHING_DELIVERY, DeliveryPhase.DISPATCHING_RETURN -> 20;
            case DeliveryPhase.HANDLING_DELIVERY, DeliveryPhase.HANDLING_RETURN -> 10;
        };
    }

    default public void phaseStarted(ServerLevel level, Delivery delivery) {
        if (delivery.getPhase() == DeliveryPhase.STARTED) {
            Mail.setSender(delivery.getMail(), delivery.getSender());
            Mail.writeToLog(delivery.getMail(), DeliveryRecord.sentFrom(delivery.getSender(), level.getGameTime()));
        }
    }

    default public void phaseTicked(ServerLevel level, Delivery delivery) {
    }

    default public void phaseCompleted(ServerLevel level, Delivery delivery) {
        if (delivery.getMail().isEmpty()) {
            return;
        }
        switch (delivery.getPhase()) {
            case HANDLING_DELIVERY: {
                ItemStack result = MailService.of(level).deliverMail(delivery.getRecipient(), delivery.getMail());
                delivery.setMail(result);
                break;
            }
            case HANDLING_RETURN: {
                ItemStack result = MailService.of(level).deliverMail(delivery.getSender(), delivery.getMail());
                delivery.setMail(result);
            }
        }
    }

    default public void endDelivery(ServerLevel level, Delivery delivery) {
    }

    default public boolean dispatchDelivery(ServerLevel level, Delivery delivery) {
        MailService mailService = MailService.of(level);
        if (!mailService.getDeliveryManager().canDeliverTo(delivery.getRecipient())) {
            Mail.writeToLog(delivery.getMail(), DeliveryRecord.returned(DeliveryRecord.Message.RECIPIENT_NOT_FOUND));
            Mail.setReturned(delivery.getMail());
            delivery.setPhaseAndResetProgress(DeliveryPhase.TRAVELING_FROM_HUB_TO_SENDER);
            return true;
        }
        if (mailService.getPaybackDepartment().tryHandleDelivery(delivery)) {
            return true;
        }
        delivery.updateRoute(level);
        return false;
    }

    default public boolean dispatchReturn(ServerLevel level, Delivery delivery) {
        if (MailService.of(level).getPaybackDepartment().tryHandleReturn(delivery)) {
            return true;
        }
        if (this.getOrigin().isService() && delivery.getMail().isEmpty()) {
            LogUtils.getLogger().debug("Finishing service delivery [{}] early, as it does not carry returning mail.", (Object)delivery.getId());
            delivery.setPhaseAndResetProgress(DeliveryPhase.FINISHED);
            return true;
        }
        delivery.updateRoute(level);
        return false;
    }
}

