/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.delivery;

import io.github.mortuusars.envelope.world.delivery.Courier;
import io.github.mortuusars.envelope.world.delivery.Delivery;
import io.github.mortuusars.envelope.world.delivery.background.BackgroundCourier;
import io.github.mortuusars.envelope.world.entity.SpawnableEntityData;
import io.github.mortuusars.envelope.world.service.MailService;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public interface TransitionableCourier
extends Courier {
    public SpawnableEntityData toSpawnableData();

    public void setDelivery(Delivery var1);

    default public BackgroundCourier transitionToBackground(ServerLevel level) {
        Delivery delivery = this.getCurrentDelivery().orElseThrow(() -> new IllegalStateException("Cannot transition: courier is not delivering."));
        BackgroundCourier backgroundCourier = new BackgroundCourier(this.toSpawnableData(), this.getOrigin(), delivery);
        MailService.of(level).getBackgroundDelivery().addCourier(backgroundCourier);
        this.onVanished(level);
        ((Entity)this).discard();
        return backgroundCourier;
    }

    default public void onAppeared(ServerLevel level) {
        Vec3 pos = ((Entity)this).position();
        level.sendParticles((ParticleOptions)ParticleTypes.CLOUD, pos.x, pos.y, pos.z, 16, 0.1, 0.1, 0.1, 0.05);
        level.playSound(null, pos.x, pos.y, pos.z, SoundEvents.BUBBLE_COLUMN_BUBBLE_POP, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    default public void onVanished(ServerLevel level) {
        Vec3 pos = ((Entity)this).position();
        level.sendParticles((ParticleOptions)ParticleTypes.CLOUD, pos.x, pos.y, pos.z, 16, 0.1, 0.1, 0.1, 0.05);
        level.playSound(null, pos.x, pos.y, pos.z, SoundEvents.BUBBLE_COLUMN_BUBBLE_POP, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }
}

