/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.delivery.background;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.delivery.background.BackgroundCourier;
import io.github.mortuusars.envelope.world.delivery.background.FinishedBackgroundCourier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class BackgroundDelivery
extends SavedData {
    public static final Codec<BackgroundDelivery> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(BackgroundCourier.CODEC).optionalFieldOf("couriers", Collections.emptyList()).forGetter(BackgroundDelivery::getCouriers), (App)Codec.list(FinishedBackgroundCourier.CODEC).optionalFieldOf("finished_couriers", Collections.emptyList()).forGetter(BackgroundDelivery::getFinishedCouriers)).apply((Applicative)instance, BackgroundDelivery::new));
    protected final List<BackgroundCourier> couriers;
    protected final List<BackgroundCourier> pendingCouriers = new ArrayList<BackgroundCourier>();
    protected final List<FinishedBackgroundCourier> finishedCouriers;

    public BackgroundDelivery(List<BackgroundCourier> couriers, List<FinishedBackgroundCourier> finishedCouriers) {
        this.couriers = new ArrayList<BackgroundCourier>(couriers);
        this.finishedCouriers = new ArrayList<FinishedBackgroundCourier>(finishedCouriers);
    }

    public BackgroundDelivery() {
        this(Collections.emptyList(), Collections.emptyList());
    }

    public List<BackgroundCourier> getCouriers() {
        return this.couriers;
    }

    public List<FinishedBackgroundCourier> getFinishedCouriers() {
        return this.finishedCouriers;
    }

    public void addCourier(BackgroundCourier courier) {
        this.pendingCouriers.add(courier);
        this.setDirty();
    }

    public void removeCourier(BackgroundCourier courier) {
        if (this.couriers.remove(courier)) {
            this.setDirty();
        }
    }

    public void addFinishedCourier(FinishedBackgroundCourier courier) {
        this.finishedCouriers.add(courier);
        this.setDirty();
    }

    public void removeFinishedCourier(FinishedBackgroundCourier courier) {
        if (this.finishedCouriers.remove(courier)) {
            this.setDirty();
        }
    }

    public void tick(ServerLevel level) {
        this.couriers.removeIf(courier -> {
            courier.tick(level);
            boolean ended = courier.getDelivery().isEnded();
            if (ended && courier.getOrigin().isRegular()) {
                FinishedBackgroundCourier finishedCourier = new FinishedBackgroundCourier(courier.getEntityData(), courier.getOrigin().getPos(), courier.getDelivery().getMail());
                this.addFinishedCourier(finishedCourier);
            }
            return ended;
        });
        this.processPendingCouriers();
    }

    protected void processPendingCouriers() {
        this.couriers.addAll(this.pendingCouriers);
        this.pendingCouriers.clear();
    }

    public static BackgroundDelivery get(ServerLevel level, String name) {
        return (BackgroundDelivery)level.getDataStorage().computeIfAbsent(BackgroundDelivery.factory(), name);
    }

    public boolean isDirty() {
        return !this.couriers.isEmpty() || super.isDirty();
    }

    @NotNull
    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        this.processPendingCouriers();
        return CODEC.encode((Object)this, (DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).ifError(e -> Envelope.LOGGER.error("Cannot save BackgroundDelivery: {}", (Object)e.message())).result().filter(t -> t instanceof CompoundTag).map(t -> (CompoundTag)t).orElse(tag);
    }

    private static BackgroundDelivery load(CompoundTag tag, HolderLookup.Provider registries) {
        return CODEC.decode((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).ifError(e -> Envelope.LOGGER.error("Cannot load BackgroundDelivery: {}", (Object)e.message())).result().map(Pair::getFirst).orElseGet(BackgroundDelivery::new);
    }

    private static SavedData.Factory<BackgroundDelivery> factory() {
        return new SavedData.Factory(BackgroundDelivery::new, BackgroundDelivery::load, null);
    }
}

