/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.util.bugger.Bugger;
import io.github.mortuusars.envelope.world.Position;
import io.github.mortuusars.envelope.world.block.occupiable.Occupiable;
import io.github.mortuusars.envelope.world.delivery.Courier;
import io.github.mortuusars.envelope.world.delivery.CourierOrigin;
import io.github.mortuusars.envelope.world.delivery.Delivery;
import io.github.mortuusars.envelope.world.delivery.DeliveryHandler;
import io.github.mortuusars.envelope.world.delivery.TransitionableCourier;
import io.github.mortuusars.envelope.world.entity.PigeonDeliveryHandler;
import io.github.mortuusars.envelope.world.entity.PigeonVariant;
import io.github.mortuusars.envelope.world.entity.SpawnableEntityData;
import io.github.mortuusars.envelope.world.entity.ai.MailboxHandler;
import io.github.mortuusars.envelope.world.entity.ai.PigeonholeHandler;
import io.github.mortuusars.envelope.world.entity.ai.goal.PigeonAvoidEntityGoal;
import io.github.mortuusars.envelope.world.entity.ai.goal.PigeonDeliverMailGoal;
import io.github.mortuusars.envelope.world.entity.ai.goal.PigeonEnterPigeonholeGoal;
import io.github.mortuusars.envelope.world.entity.ai.goal.PigeonGoToMailboxGoal;
import io.github.mortuusars.envelope.world.entity.ai.goal.PigeonGoToPigeonholeGoal;
import io.github.mortuusars.envelope.world.entity.ai.goal.PigeonLocateMailboxGoal;
import io.github.mortuusars.envelope.world.entity.ai.goal.PigeonLocatePigeonholeGoal;
import io.github.mortuusars.envelope.world.entity.ai.goal.PigeonPanicGoal;
import io.github.mortuusars.envelope.world.entity.ai.goal.PigeonSitGoal;
import io.github.mortuusars.envelope.world.entity.ai.goal.PigeonStartDeliveryFromMailboxGoal;
import io.github.mortuusars.envelope.world.entity.ai.goal.PigeonWanderGoal;
import io.github.mortuusars.envelope.world.item.mail.Mail;
import io.github.mortuusars.envelope.world.service.MailService;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class Pigeon
extends Animal
implements VariantHolder<PigeonVariant>,
FlyingAnimal,
TransitionableCourier {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final List<String> IGNORED_TAGS = Arrays.asList("Air", "ArmorDropChances", "ArmorItems", "Brain", "CanPickUpLoot", "DeathTime", "FallDistance", "FallFlying", "Fire", "HandDropChances", "HandItems", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "NoGravity", "OnGround", "PortalCooldown", "Pos", "Rotation", "SleepingX", "SleepingY", "SleepingZ", "Passengers", "UUID", "leash", "Sitting", "Delivery");
    public static final Predicate<LivingEntity> AVOID_SELECTOR = entity -> {
        if (entity instanceof Cat) {
            return (Boolean)Config.Server.PIGEON_HUNTED_BY_CAT.get();
        }
        if (entity instanceof Ocelot) {
            return (Boolean)Config.Server.PIGEON_HUNTED_BY_OCELOT.get();
        }
        if (entity instanceof Fox) {
            return (Boolean)Config.Server.PIGEON_HUNTED_BY_FOX.get();
        }
        return false;
    };
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.defineId(Pigeon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_DELIVERING = SynchedEntityData.defineId(Pigeon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_HAS_MAIL = SynchedEntityData.defineId(Pigeon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_SERVICE = SynchedEntityData.defineId(Pigeon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_TIRED = SynchedEntityData.defineId(Pigeon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    protected float flapping = 1.0f;
    protected float nextFlap = 1.0f;
    protected int tiredTicks;
    protected PigeonholeHandler pigeonholeHandler;
    protected MailboxHandler mailboxHandler;
    protected PigeonDeliveryHandler deliveryHandler;
    @Nullable
    protected Delivery delivery;
    @Nullable
    protected CourierOrigin origin;

    public Pigeon(EntityType<? extends Pigeon> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, false);
        this.pigeonholeHandler = new PigeonholeHandler();
        this.pigeonholeHandler.setRandomWantCooldownUpToDefault(level.getRandom());
        this.mailboxHandler = new MailboxHandler();
        this.deliveryHandler = new PigeonDeliveryHandler(this);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
    }

    public static boolean checkSpawnRules(EntityType<Pigeon> pigeon, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return (Boolean)Config.Server.PIGEON_SPAWNS_NATURALLY.get() != false && level.getBlockState(pos.below()).is(Envelope.Tags.Blocks.PIGEONS_SPAWNABLE_ON) && Pigeon.isBrightEnoughToSpawn((BlockAndTintGetter)level, (BlockPos)pos);
    }

    public static Pigeon createService(ServerLevel level) {
        Pigeon pigeon = Objects.requireNonNull((Pigeon)Envelope.EntityTypes.PIGEON.get().create((Level)level), "Failed to create an entity. This should not happen.");
        pigeon.setVariant(PigeonVariant.getRandomService(level.getRandom()));
        pigeon.setOrigin(CourierOrigin.service());
        return pigeon;
    }

    public static Courier spawnServiceCourier(ServerLevel level, Delivery delivery) {
        Pigeon pigeon = Pigeon.createService(level);
        pigeon.startDelivery(delivery);
        return pigeon.transitionToBackground(level);
    }

    @NotNull
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        Holder biome = level.getBiome(this.blockPosition());
        if (biome.is(Envelope.Tags.Biomes.HAS_PASSENGER_PIGEONS)) {
            this.setVariant(PigeonVariant.getRandomPassengerPriority(this.getRandom()));
        } else {
            this.setVariant(PigeonVariant.getRandomRegular(this.getRandom()));
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.FLYING_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT_ID, (Object)0);
        builder.define(DATA_DELIVERING, (Object)false);
        builder.define(DATA_SERVICE, (Object)false);
        builder.define(DATA_HAS_MAIL, (Object)false);
        builder.define(DATA_TIRED, (Object)false);
    }

    @NotNull
    public PigeonVariant getVariant() {
        return PigeonVariant.byId((Integer)this.entityData.get(DATA_VARIANT_ID));
    }

    public void setVariant(PigeonVariant variant) {
        this.entityData.set(DATA_VARIANT_ID, (Object)variant.getId());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new PigeonDeliverMailGoal(this));
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, new PigeonAvoidEntityGoal<Animal>(this, Animal.class, 8.0f, 1.5, 3.5, AVOID_SELECTOR));
        this.goalSelector.addGoal(2, (Goal)new PigeonPanicGoal((PathfinderMob)this, 3.5));
        this.goalSelector.addGoal(2, (Goal)new PigeonEnterPigeonholeGoal(this));
        this.goalSelector.addGoal(3, (Goal)new PigeonStartDeliveryFromMailboxGoal(this));
        this.goalSelector.addGoal(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new TemptGoal((PathfinderMob)this, 1.25, itemStack -> itemStack.is(Envelope.Tags.Items.PIGEON_FOOD), false));
        this.goalSelector.addGoal(6, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(7, (Goal)new PigeonLocatePigeonholeGoal(this));
        this.goalSelector.addGoal(7, (Goal)new PigeonGoToPigeonholeGoal(this));
        this.goalSelector.addGoal(7, (Goal)new PigeonLocateMailboxGoal(this));
        this.goalSelector.addGoal(7, (Goal)new PigeonSitGoal(this));
        this.goalSelector.addGoal(8, (Goal)new PigeonGoToMailboxGoal(this));
        this.goalSelector.addGoal(9, (Goal)new PigeonWanderGoal(this));
        this.goalSelector.addGoal(11, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    @NotNull
    protected FlyingPathNavigation createNavigation(Level level) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, level);
        navigation.setCanOpenDoors(false);
        navigation.setCanFloat(true);
        navigation.setCanPassDoors(true);
        return navigation;
    }

    public void aiStep() {
        super.aiStep();
        this.calculateFlapping();
        if (this.tiredTicks > 0) {
            this.setTiredTicks(this.tiredTicks - 1);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if ((double)this.level().getRandom().nextFloat() < 0.1) {
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.position().x, this.position().y, this.position().z, 1, 0.2, 0.2, 0.2, 0.0);
                }
            }
        }
        if (this.isSitting() && this.getNavigation().isInProgress()) {
            this.setSitting(false);
        }
        this.getPigeonholeHandler().tick(this, this.level());
        this.getMailboxHandler().tick(this, this.level());
    }

    public void checkDespawn() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (!this.isNoAi() && this.isDelivering() && !Position.isInSimulationDistance(level2, (Entity)this)) {
                this.transitionToBackground(level2);
                return;
            }
        }
        super.checkDespawn();
    }

    protected void calculateFlapping() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed += (float)(!this.onGround() && !this.isPassenger() ? 4 : -1) * 0.3f;
        this.flapSpeed = Mth.clamp((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.onGround() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping *= 0.9f;
        Vec3 vec3 = this.getDeltaMovement();
        if (!this.onGround() && vec3.y < 0.0) {
            float descendRate = this.getDescendRate();
            this.setDeltaMovement(vec3.multiply(1.0, (double)descendRate, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    protected float getDescendRate() {
        if (this.delivery != null) {
            if (this.delivery.getPhase().isDescending()) {
                return 0.9f;
            }
            if (this.delivery.getPhase().isAscending()) {
                return 0.5f;
            }
        }
        return 0.75f;
    }

    protected boolean shouldDropLoot() {
        return super.shouldDropLoot() && (this.origin == null || !this.origin.isService());
    }

    protected void dropAllDeathLoot(ServerLevel level, DamageSource damageSource) {
        super.dropAllDeathLoot(level, damageSource);
        this.getCurrentDelivery().ifPresent(delivery -> this.diedWhileDelivering(level, damageSource, (Delivery)delivery));
    }

    protected void diedWhileDelivering(ServerLevel level, DamageSource damageSource, Delivery delivery) {
        String message = damageSource.getLocalizedDeathMessage((LivingEntity)this).getString();
        String carriedItem = !delivery.getMail().isEmpty() ? " a " + delivery.getMail().getHoverName().getString() : "";
        String addresses = delivery.getSender().getName().getString() + " to " + delivery.getRecipient().getName().getString();
        Envelope.LOGGER.info("{} at [{}] while delivering{} from {}!", new Object[]{message, this.blockPosition().toShortString(), carriedItem, addresses});
        if (!this.getOrigin().isService()) {
            MailService.of(level).sendCourierDeathNotice((LivingEntity)this, delivery, damageSource);
        }
        if (!delivery.getMail().isEmpty()) {
            ItemStack mail = delivery.getPhase().isOnRecipientSide() ? Mail.asDelivered(delivery.getMail()) : delivery.getMail();
            this.spawnAtLocation(mail);
            delivery.setMail(ItemStack.EMPTY);
        }
    }

    public boolean isSitting() {
        return this.getPose() == Pose.SITTING;
    }

    public void setSitting(boolean sitting) {
        this.setPose(sitting ? Pose.SITTING : Pose.STANDING);
    }

    @Override
    public boolean isDelivering() {
        return (Boolean)this.entityData.get(DATA_DELIVERING);
    }

    public void setDelivering(boolean delivering) {
        this.entityData.set(DATA_DELIVERING, (Object)delivering);
    }

    public boolean hasMail() {
        return (Boolean)this.entityData.get(DATA_HAS_MAIL);
    }

    public void setHasMail(boolean hasMail) {
        this.entityData.set(DATA_HAS_MAIL, (Object)hasMail);
    }

    public boolean isService() {
        return (Boolean)this.entityData.get(DATA_SERVICE);
    }

    public void setService(boolean service) {
        this.entityData.set(DATA_SERVICE, (Object)service);
    }

    public boolean isTired() {
        if (!this.level().isClientSide) {
            return this.tiredTicks > 0;
        }
        return (Boolean)this.entityData.get(DATA_TIRED);
    }

    public int getTiredTicks() {
        return this.tiredTicks;
    }

    public void setTiredTicks(int ticks) {
        Level level;
        if (ticks <= 0 && this.tiredTicks > 0 && (level = this.level()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.position().x, this.position().y, this.position().z, 7, 0.25, 0.25, 0.25, 0.0);
        }
        this.tiredTicks = ticks;
        this.entityData.set(DATA_TIRED, (Object)(this.tiredTicks > 0 ? 1 : 0));
    }

    public boolean hasMailmanHat() {
        return this.isService();
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        @Nullable Pigeon offspring = (Pigeon)Envelope.EntityTypes.PIGEON.get().create((Level)level);
        if (offspring != null && otherParent instanceof Pigeon) {
            Pigeon otherPigeon = (Pigeon)otherParent;
            offspring.setVariant(this.getRandom().nextBoolean() ? this.getVariant() : otherPigeon.getVariant());
        }
        return offspring;
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(Envelope.Tags.Items.PIGEON_FOOD);
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.level().isClientSide()) {
            return false;
        }
        if (this.isDeadOrDying()) {
            return false;
        }
        if (this.getRandom().nextDouble() < (Double)Config.Server.PIGEON_DAMAGE_EVASION_CHANCE_WHILE_DELIVERING.get() && !source.is(Envelope.Tags.DamageTypes.BYPASSES_PIGEON_DELIVERY_EVASION)) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                level2.sendParticles((ParticleOptions)ParticleTypes.POOF, this.position().x, this.position().y, this.position().z, 3, 0.3, 0.3, 0.3, 0.0);
                level2.playSound(null, (Entity)this, SoundEvents.ALLAY_THROW, SoundSource.NEUTRAL, 1.0f, this.getRandom().nextFloat() * 0.1f + 0.95f);
            }
            return false;
        }
        return super.hurt(source, amount);
    }

    protected boolean isFlapping() {
        return this.flyDist > this.nextFlap;
    }

    protected void onFlap() {
        this.playSound(Envelope.SoundEvents.PIGEON_FLY.get(), 0.15f, 1.0f);
        this.nextFlap = this.flyDist + this.flapSpeed / 2.0f;
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    protected float getFlyingSpeed() {
        return this.isPanicking() ? 0.035f : 0.0275f;
    }

    @NotNull
    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(this.getEyeHeight() * 0.65f), (double)(this.getBbWidth() * 0.4f));
    }

    public boolean hasReachedTarget(BlockPos pos) {
        return this.hasReachedTarget(pos, 2);
    }

    protected boolean hasReachedTarget(BlockPos pos, int distance) {
        if (this.closerThan(pos, distance)) {
            return true;
        }
        Path path = this.getNavigation().getPath();
        return path != null && path.getTarget().equals((Object)pos) && path.canReach() && path.isDone();
    }

    public boolean closerThan(BlockPos pos, int distance) {
        return pos.closerThan((Vec3i)this.blockPosition(), (double)distance);
    }

    public boolean pathfindDirectlyTowards(BlockPos pos) {
        this.getNavigation().setMaxVisitedNodesMultiplier(10.0f);
        this.getNavigation().moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 2, 1.0);
        return this.getNavigation().getPath() != null && this.getNavigation().getPath().canReach();
    }

    public void pathfindRandomlyTowards(BlockPos pos) {
        Vec3 vec32;
        Vec3 vec3 = Vec3.atBottomCenterOf((Vec3i)pos);
        int i = 0;
        BlockPos blockPos = this.blockPosition();
        int j = (int)vec3.y - blockPos.getY();
        if (j > 2) {
            i = 4;
        } else if (j < -2) {
            i = -4;
        }
        int k = 6;
        int l = 8;
        int m = blockPos.distManhattan((Vec3i)pos);
        if (m < 15) {
            k = m / 2;
            l = m / 2;
        }
        if ((vec32 = AirRandomPos.getPosTowards((PathfinderMob)this, (int)k, (int)l, (int)i, (Vec3)vec3, (double)0.3141592741012573)) != null) {
            this.navigation.setMaxVisitedNodesMultiplier(1.0f);
            this.navigation.moveTo(vec32.x, vec32.y, vec32.z, 1.0);
        }
    }

    @NotNull
    public PigeonholeHandler getPigeonholeHandler() {
        return this.pigeonholeHandler;
    }

    public void setPigeonholeHandler(PigeonholeHandler handler) {
        this.pigeonholeHandler = handler;
    }

    public void releasedFromPigeonhole(BlockPos pos, BlockState state, Occupiable.ReleaseReason releaseReason) {
        this.getPigeonholeHandler().setTargetPos(pos);
        this.getPigeonholeHandler().setLastReleasePos(pos);
        this.getPigeonholeHandler().setDefaultWantCooldown();
        if (releaseReason == Occupiable.ReleaseReason.EMERGENCY) {
            this.getPigeonholeHandler().setEnterCooldown(200);
        }
        this.getMailboxHandler().setLocateCooldown(this.level().getRandom().nextInt(20, 100));
        if (this.isTired()) {
            this.setTiredTicks(0);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                level2.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.position().x, this.position().y, this.position().z, 5, 0.25, 0.25, 0.25, 0.0);
            }
        }
    }

    public MailboxHandler getMailboxHandler() {
        return this.mailboxHandler;
    }

    public Pigeon setMailboxHandler(MailboxHandler mailboxHandler) {
        this.mailboxHandler = mailboxHandler;
        return this;
    }

    @Nullable
    public SoundEvent getAmbientSound() {
        return Envelope.SoundEvents.PIGEON_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return Envelope.SoundEvents.PIGEON_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return Envelope.SoundEvents.PIGEON_DEATH.get();
    }

    public void playSound(SoundEvent sound, float volume, float pitch) {
        if (!this.isSilent()) {
            this.level().playSound(null, (Entity)this, sound, this.getSoundSource(), volume, pitch);
        }
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(Envelope.SoundEvents.PIGEON_STEP.get(), 0.15f, 1.0f);
    }

    public float getVoicePitch() {
        return Pigeon.getPitch(this.random) + (this.isBaby() ? 0.3f : 0.0f);
    }

    public static float getPitch(RandomSource random) {
        return (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f;
    }

    @NotNull
    public SoundSource getSoundSource() {
        return SoundSource.NEUTRAL;
    }

    public boolean isPushable() {
        return true;
    }

    protected void doPush(Entity entity) {
        if (!(entity instanceof Player)) {
            super.doPush(entity);
        }
    }

    @Override
    public DeliveryHandler getDeliveryHandler() {
        return this.deliveryHandler;
    }

    public boolean canStartDelivery() {
        return !this.isTired() && !this.level().isNight() && !this.level().isRaining() && !this.level().isThundering();
    }

    public Courier startDelivery(Delivery delivery) {
        if (this.delivery != null && this.delivery != delivery) {
            LOGGER.warn("Starting new delivery when pigeon is already delivering. This might be an error.");
        }
        if (this.origin == null || !this.origin.isService()) {
            this.setOrigin(CourierOrigin.regular(this.blockPosition()));
        }
        this.stopRiding();
        this.setDelivery(delivery);
        return this;
    }

    @Override
    public Optional<Delivery> getCurrentDelivery() {
        return Optional.ofNullable(this.delivery);
    }

    @Override
    public void setDelivery(@Nullable Delivery delivery) {
        if (delivery == null && this.delivery == null) {
            return;
        }
        this.delivery = delivery;
        this.onDeliveryChanged();
    }

    public void onDeliveryChanged() {
        if (!this.level().isClientSide()) {
            this.setDelivering(this.getCurrentDelivery().isPresent());
            this.setHasMail(this.delivery != null && !this.delivery.getMail().isEmpty());
            Bugger.PIGEON_DELIVERY.send(this.getId(), Optional.ofNullable(this.delivery));
        }
    }

    @Override
    @NotNull
    public CourierOrigin getOrigin() {
        if (this.origin == null) {
            LOGGER.warn("Origin of a Pigeon was not set properly. Current position will be used as origin instead.");
            this.origin = CourierOrigin.regular(this.blockPosition());
        }
        return this.origin;
    }

    public void setOrigin(@Nullable CourierOrigin origin) {
        this.origin = origin;
        this.setService(origin != null && origin.isService());
    }

    @Override
    public SpawnableEntityData toSpawnableData() {
        return SpawnableEntityData.of((Entity)this, IGNORED_TAGS);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("PigeonholeHandler", (Tag)PigeonholeHandler.CODEC.encode((Object)this.getPigeonholeHandler(), (DynamicOps)NbtOps.INSTANCE, (Object)tag).getOrThrow());
        tag.put("MailboxHandler", (Tag)MailboxHandler.CODEC.encode((Object)this.getMailboxHandler(), (DynamicOps)NbtOps.INSTANCE, (Object)tag).getOrThrow());
        tag.putInt("Variant", this.getVariant().getId());
        if (this.isSitting()) {
            tag.putBoolean("Sitting", true);
        }
        if (this.tiredTicks > 0) {
            tag.putInt("TiredTicks", this.tiredTicks);
        }
        if (this.delivery != null) {
            Delivery.CODEC.encodeStart((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.delivery).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(value -> tag.put("Delivery", value));
        }
        if (this.origin != null) {
            CourierOrigin.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.origin).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(value -> tag.put("Origin", value));
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setPigeonholeHandler((PigeonholeHandler)PigeonholeHandler.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("PigeonholeHandler")).getOrThrow());
        this.setMailboxHandler((MailboxHandler)MailboxHandler.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("MailboxHandler")).getOrThrow());
        this.setVariant(PigeonVariant.byId(tag.getInt("Variant")));
        this.setSitting(tag.getBoolean("Sitting"));
        this.setTiredTicks(tag.getInt("TiredTicks"));
        if (tag.contains("Delivery")) {
            this.setDelivery(Delivery.CODEC.parse((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.getCompound("Delivery")).resultOrPartial(e -> LOGGER.error("Cannot parse Delivery from tag '{}': {}", (Object)tag.getCompound("Delivery"), e)).orElse(null));
        }
        if (tag.contains("Origin")) {
            this.setOrigin(CourierOrigin.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("Origin")).resultOrPartial(e -> LOGGER.error("Cannot parse CourierOrigin from tag '{}': {}", (Object)tag.getCompound("Origin"), e)).orElse(null));
        }
        this.setDelivering(this.delivery != null);
        this.setHasMail(this.delivery != null && !this.delivery.getMail().isEmpty());
    }
}

