/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.entity;

import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.world.delivery.CourierOrigin;
import io.github.mortuusars.envelope.world.delivery.Delivery;
import io.github.mortuusars.envelope.world.delivery.DeliveryHandler;
import io.github.mortuusars.envelope.world.delivery.phase.DeliveryPhase;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import io.github.mortuusars.envelope.world.item.component.mail.log.DeliveryRecord;
import io.github.mortuusars.envelope.world.item.mail.Mail;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;

public class PigeonDeliveryHandler
implements DeliveryHandler {
    private final Pigeon pigeon;

    public PigeonDeliveryHandler(Pigeon pigeon) {
        this.pigeon = pigeon;
    }

    public Pigeon pigeon() {
        return this.pigeon;
    }

    @Override
    public CourierOrigin getOrigin() {
        return this.pigeon.getOrigin();
    }

    @Override
    public int getPhaseDuration(ServerLevel level, Delivery delivery, DeliveryPhase phase) {
        return switch (phase) {
            case DeliveryPhase.DEPARTING_SENDER, DeliveryPhase.APPROACHING_RECIPIENT, DeliveryPhase.DEPARTING_RECIPIENT, DeliveryPhase.APPROACHING_SENDER -> 600;
            default -> DeliveryHandler.super.getPhaseDuration(level, delivery, phase);
        };
    }

    @Override
    public void phaseStarted(ServerLevel level, Delivery delivery) {
        DeliveryHandler.super.phaseStarted(level, delivery);
        if (delivery.getPhase().isTraveling()) {
            this.pigeon().transitionToBackground(level);
        }
        this.pigeon().onDeliveryChanged();
    }

    @Override
    public boolean handlePhaseTransition(ServerLevel level, Delivery delivery) {
        if (delivery.getPhase() == DeliveryPhase.DEPARTING_SENDER && !this.hasReachedSegmentEndPos(delivery)) {
            Mail.writeToLog(delivery.getMail(), DeliveryRecord.returned(DeliveryRecord.Message.UNABLE_TO_REACH));
            delivery.setPhaseAndResetProgress(DeliveryPhase.APPROACHING_SENDER);
            return true;
        }
        if (delivery.getPhase() == DeliveryPhase.APPROACHING_RECIPIENT && !this.hasReachedSegmentEndPos(delivery)) {
            Mail.writeToLog(delivery.getMail(), DeliveryRecord.returned(DeliveryRecord.Message.UNABLE_TO_REACH));
            delivery.setPhaseAndResetProgress(DeliveryPhase.DEPARTING_RECIPIENT);
            return true;
        }
        return DeliveryHandler.super.handlePhaseTransition(level, delivery);
    }

    @Override
    public void endDelivery(ServerLevel level, Delivery delivery) {
        if (!delivery.getMail().isEmpty()) {
            this.pigeon().spawnAtLocation(delivery.getMail().copy());
            Pigeon.LOGGER.info("{} has dropped undelivered mail on the ground.", (Object)this.pigeon().getName().getString());
            delivery.setMail(ItemStack.EMPTY);
        }
        this.pigeon().setDelivery(null);
        if (this.pigeon().getOrigin().isService()) {
            this.pigeon().onVanished(level);
            this.pigeon().discard();
        } else {
            this.pigeon().setOrigin(null);
            this.pigeon().getPigeonholeHandler().setTargetPos(this.pigeon().getPigeonholeHandler().getLastReleasePos());
            this.pigeon().getPigeonholeHandler().setWantCooldown(20);
            this.pigeon().setTiredTicks((Integer)Config.Server.PIGEON_TIRED_AFTER_DELIVERY_TICKS.get());
        }
    }

    protected boolean hasReachedSegmentEndPos(Delivery delivery) {
        return delivery.getRoute().getSegment(delivery.getPhase()).endPos().map(pos -> this.pigeon().hasReachedTarget((BlockPos)pos)).orElse(true);
    }
}

