/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.entity;

import com.mojang.serialization.Codec;
import java.util.function.IntFunction;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import org.jetbrains.annotations.NotNull;

public enum PigeonVariant implements StringRepresentable
{
    GRAY(0, "gray"),
    BROWN(1, "brown"),
    WHITE(2, "white"),
    PASSENGER(3, "passenger");

    public static final Codec<PigeonVariant> CODEC;
    private static final IntFunction<PigeonVariant> BY_ID;
    public static final WeightedRandomList<WeightedEntry.Wrapper<PigeonVariant>> SERVICE_POOL;
    public static final WeightedRandomList<WeightedEntry.Wrapper<PigeonVariant>> REGULAR_BIOME_POOL;
    public static final WeightedRandomList<WeightedEntry.Wrapper<PigeonVariant>> HAS_PASSENGER_PIGEON_BIOME_POOL;
    private final int id;
    private final String name;

    private PigeonVariant(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    public static PigeonVariant byId(int id) {
        return BY_ID.apply(id);
    }

    public static PigeonVariant getRandomRegular(RandomSource random) {
        return (PigeonVariant)((Object)((WeightedEntry.Wrapper)REGULAR_BIOME_POOL.getRandom(random).orElseThrow()).data());
    }

    public static PigeonVariant getRandomPassengerPriority(RandomSource random) {
        return (PigeonVariant)((Object)((WeightedEntry.Wrapper)HAS_PASSENGER_PIGEON_BIOME_POOL.getRandom(random).orElseThrow()).data());
    }

    public static PigeonVariant getRandomService(RandomSource random) {
        return (PigeonVariant)((Object)((WeightedEntry.Wrapper)SERVICE_POOL.getRandom(random).orElseThrow()).data());
    }

    static {
        CODEC = StringRepresentable.fromEnum(PigeonVariant::values);
        BY_ID = ByIdMap.continuous(PigeonVariant::getId, (Object[])PigeonVariant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        SERVICE_POOL = WeightedRandomList.create((WeightedEntry[])new WeightedEntry.Wrapper[]{new WeightedEntry.Wrapper((Object)GRAY, Weight.of((int)16)), new WeightedEntry.Wrapper((Object)BROWN, Weight.of((int)8)), new WeightedEntry.Wrapper((Object)WHITE, Weight.of((int)4)), new WeightedEntry.Wrapper((Object)PASSENGER, Weight.of((int)2))});
        REGULAR_BIOME_POOL = WeightedRandomList.create((WeightedEntry[])new WeightedEntry.Wrapper[]{new WeightedEntry.Wrapper((Object)GRAY, Weight.of((int)10)), new WeightedEntry.Wrapper((Object)BROWN, Weight.of((int)4)), new WeightedEntry.Wrapper((Object)WHITE, Weight.of((int)1))});
        HAS_PASSENGER_PIGEON_BIOME_POOL = WeightedRandomList.create((WeightedEntry[])new WeightedEntry.Wrapper[]{new WeightedEntry.Wrapper((Object)PASSENGER, Weight.of((int)16)), new WeightedEntry.Wrapper((Object)GRAY, Weight.of((int)6)), new WeightedEntry.Wrapper((Object)BROWN, Weight.of((int)4)), new WeightedEntry.Wrapper((Object)WHITE, Weight.of((int)1))});
    }
}

