/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.entity;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.List;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public record SpawnableEntityData(CustomData data) {
    public static final Codec<SpawnableEntityData> CODEC = CustomData.CODEC.validate(data -> {
        if (data.isEmpty()) {
            return DataResult.error(() -> "Entity data cannot be empty.");
        }
        return DataResult.success((Object)data);
    }).xmap(SpawnableEntityData::new, SpawnableEntityData::data);
    private static final Logger LOGGER = LogUtils.getLogger();

    public SpawnableEntityData {
        Preconditions.checkArgument((!data.isEmpty() ? 1 : 0) != 0, (Object)"Entity data cannot be empty.");
        Preconditions.checkState((!data.getUnsafe().isEmpty() ? 1 : 0) != 0, (Object)"Entity tag cannot be empty.");
        Preconditions.checkState((boolean)data.getUnsafe().contains("id", 8), (Object)("Entity tag does not contain an 'id': " + String.valueOf(data.getClass())));
    }

    public static SpawnableEntityData of(Entity entity, List<String> ignoredTags) {
        Preconditions.checkArgument((!entity.isPassenger() && !entity.isRemoved() && entity.getType().canSerialize() ? 1 : 0) != 0, (Object)("Cannot create SpawnableEntityData: entity '" + String.valueOf(entity) + "' is passenger, removed or the type is not serializable."));
        CompoundTag tag = new CompoundTag();
        if (!entity.save(tag)) {
            LOGGER.error("Failed to save entity '{}' to a tag. Entity is passenger, about to be removed or entity type is not serializable.", (Object)entity);
        }
        ignoredTags.forEach(arg_0 -> ((CompoundTag)tag).remove(arg_0));
        return new SpawnableEntityData(CustomData.of((CompoundTag)tag));
    }

    @Nullable
    public Entity createEntity(ServerLevel level) {
        return EntityType.loadEntityRecursive((CompoundTag)this.data.getUnsafe(), (Level)level, Function.identity());
    }
}

