/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.entity.ai;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.envelope.util.bugger.Bugger;
import io.github.mortuusars.envelope.world.block.mailbox.MailboxBlockEntity;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class MailboxHandler {
    public static final int MAX_BLACKLISTED_TARGETS = 3;
    public static final int DEFAULT_LOCATE_COOLDOWN = 100;
    public static final Codec<MailboxHandler> CODEC = RecordCodecBuilder.create(i -> i.group((App)BlockPos.CODEC.optionalFieldOf("target_pos").forGetter(o -> Optional.ofNullable(o.getTargetPos())), (App)Codec.INT.optionalFieldOf("locate_cooldown", (Object)0).forGetter(MailboxHandler::getLocateCooldown)).apply((Applicative)i, MailboxHandler::new));
    protected final List<BlockPos> blacklistedPositions = new ArrayList<BlockPos>();
    @Nullable
    protected BlockPos targetPos;
    protected int locateCooldown;

    public MailboxHandler(Optional<BlockPos> targetPos, int locateCooldown) {
        this.targetPos = targetPos.orElse(null);
        this.locateCooldown = locateCooldown;
    }

    public MailboxHandler() {
        this(Optional.empty(), 0);
    }

    @Nullable
    public BlockPos getTargetPos() {
        return this.targetPos;
    }

    public void setTargetPos(@Nullable BlockPos targetPos) {
        this.targetPos = targetPos;
    }

    public int getLocateCooldown() {
        return this.locateCooldown;
    }

    public void setLocateCooldown(int cooldown) {
        this.locateCooldown = cooldown;
    }

    public void resetLocateCooldown() {
        this.setLocateCooldown(100);
    }

    public void tick(Pigeon pigeon, Level level) {
        if (this.locateCooldown > 0) {
            --this.locateCooldown;
        }
        if (level instanceof ServerLevel && pigeon.tickCount % 20 == 0) {
            if (!this.isMailboxValid(level, pigeon.blockPosition())) {
                this.setTargetPos(null);
            }
            Bugger.PIGEON_MAILBOX_HANDLER.send(pigeon.getId(), this);
        }
    }

    public boolean canStartDelivery(Pigeon pigeon) {
        return !pigeon.isTired();
    }

    public Optional<MailboxBlockEntity> getMailboxAtCurrentPos(Level level) {
        BlockEntity blockEntity;
        @Nullable BlockPos pos = this.getTargetPos();
        if (pos != null && level.isLoaded(pos) && (blockEntity = level.getBlockEntity(pos)) instanceof MailboxBlockEntity) {
            MailboxBlockEntity be = (MailboxBlockEntity)blockEntity;
            return Optional.of(be);
        }
        return Optional.empty();
    }

    public boolean isMailboxValid(Level level, BlockPos entityPos) {
        MailboxBlockEntity blockEntity;
        @Nullable BlockPos currentPos = this.getTargetPos();
        if (currentPos == null) {
            return false;
        }
        if (!entityPos.closerThan((Vec3i)currentPos, 32.0)) {
            return false;
        }
        BlockEntity blockEntity2 = level.getBlockEntity(currentPos);
        return blockEntity2 instanceof MailboxBlockEntity && (blockEntity = (MailboxBlockEntity)blockEntity2).isAvailableForPickup();
    }

    public boolean isTargetBlacklisted(BlockPos pos) {
        return this.blacklistedPositions.contains(pos);
    }

    private void blacklistTarget(BlockPos pos) {
        this.blacklistedPositions.add(pos);
        while (this.blacklistedPositions.size() > 3) {
            this.blacklistedPositions.removeFirst();
        }
    }

    public void clearBlacklist() {
        this.blacklistedPositions.clear();
    }

    public void dropAndBlacklistMailbox() {
        if (this.getTargetPos() != null) {
            this.blacklistTarget(this.getTargetPos());
        }
        this.dropMailbox();
    }

    public void dropMailbox() {
        this.setTargetPos(null);
        this.resetLocateCooldown();
    }

    public String toString() {
        return "MailboxHandler{, targetPos=" + String.valueOf(this.targetPos) + ", locateCooldown=" + this.locateCooldown + "}";
    }
}

