/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.entity.ai;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.util.bugger.Bugger;
import io.github.mortuusars.envelope.world.block.PigeonholeBlockEntity;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class PigeonholeHandler {
    public static final int MAX_BLACKLISTED_TARGETS = 3;
    public static final int DEFAULT_LOCATE_COOLDOWN = 200;
    public static final Codec<PigeonholeHandler> CODEC = RecordCodecBuilder.create(i -> i.group((App)BlockPos.CODEC.optionalFieldOf("current_pos").forGetter(o -> Optional.ofNullable(o.getTargetPos())), (App)BlockPos.CODEC.optionalFieldOf("last_release_pos").forGetter(o -> Optional.ofNullable(o.getLastReleasePos())), (App)Codec.INT.optionalFieldOf("locate_cooldown", (Object)0).forGetter(PigeonholeHandler::getLocateCooldown), (App)Codec.INT.optionalFieldOf("want_cooldown", (Object)0).forGetter(PigeonholeHandler::getWantCooldown), (App)Codec.INT.optionalFieldOf("enter_cooldown", (Object)0).forGetter(PigeonholeHandler::getEnterCooldown)).apply((Applicative)i, PigeonholeHandler::new));
    protected final List<BlockPos> blacklistedPositions = new ArrayList<BlockPos>();
    @Nullable
    protected BlockPos targetPos;
    @Nullable
    protected BlockPos lastReleasePos;
    protected int locateCooldown;
    protected int wantCooldown;
    protected int enterCooldown;

    public PigeonholeHandler(Optional<BlockPos> targetPos, Optional<BlockPos> lastReleasePos, int locateCooldown, int wantCooldown, int enterCooldown) {
        this.targetPos = targetPos.orElse(null);
        this.lastReleasePos = lastReleasePos.orElse(null);
        this.locateCooldown = locateCooldown;
        this.wantCooldown = wantCooldown;
        this.enterCooldown = enterCooldown;
    }

    public PigeonholeHandler() {
        this(Optional.empty(), Optional.empty(), 0, 0, 0);
    }

    @Nullable
    public BlockPos getTargetPos() {
        return this.targetPos;
    }

    public void setTargetPos(@Nullable BlockPos targetPos) {
        this.targetPos = targetPos;
    }

    @Nullable
    public BlockPos getLastReleasePos() {
        return this.lastReleasePos;
    }

    public PigeonholeHandler setLastReleasePos(@Nullable BlockPos lastReleasePos) {
        this.lastReleasePos = lastReleasePos;
        return this;
    }

    public int getEnterCooldown() {
        return this.enterCooldown;
    }

    public void setEnterCooldown(int cooldown) {
        this.enterCooldown = cooldown;
    }

    public int getWantCooldown() {
        return this.wantCooldown;
    }

    public void setWantCooldown(int cooldown) {
        this.wantCooldown = cooldown;
    }

    public void setDefaultWantCooldown() {
        this.setWantCooldown((Integer)Config.Server.PIGEON_MIN_TICKS_OUTSIDE_PIGEONHOLE.get());
    }

    public void setRandomWantCooldownUpToDefault(RandomSource random) {
        this.setWantCooldown(random.nextInt(((Integer)Config.Server.PIGEON_MIN_TICKS_OUTSIDE_PIGEONHOLE.get()).intValue()));
    }

    public int getLocateCooldown() {
        return this.locateCooldown;
    }

    public void setLocateCooldown(int cooldown) {
        this.locateCooldown = cooldown;
    }

    public void resetLocateCooldown() {
        this.setLocateCooldown(200);
    }

    public void tick(Pigeon pigeon, Level level) {
        if (this.wantCooldown > 0) {
            --this.wantCooldown;
        }
        if (this.locateCooldown > 0) {
            --this.locateCooldown;
        }
        if (level instanceof ServerLevel && pigeon.tickCount % 20 == 0) {
            if (!this.isPigeonholeValid(level, pigeon.blockPosition())) {
                this.setTargetPos(null);
            }
            Bugger.PIGEON_PIGEONHOLE_HANDLER.send(pigeon.getId(), this);
        }
    }

    public Optional<PigeonholeBlockEntity> getPigeonholeAtCurrentPos(Level level) {
        BlockEntity blockEntity;
        @Nullable BlockPos pos = this.getTargetPos();
        if (pos != null && level.isLoaded(pos) && (blockEntity = level.getBlockEntity(pos)) instanceof PigeonholeBlockEntity) {
            PigeonholeBlockEntity be = (PigeonholeBlockEntity)blockEntity;
            return Optional.of(be);
        }
        return Optional.empty();
    }

    public boolean wantsToEnterPigeonhole(Pigeon pigeon) {
        if (this.getEnterCooldown() > 0) {
            return false;
        }
        Level level = pigeon.level();
        boolean wouldPreferInside = level.isNight() || level.isRaining() || level.isThundering();
        boolean tiredOfOutside = pigeon.isTired() || this.getWantCooldown() <= 0;
        return wouldPreferInside || tiredOfOutside;
    }

    public boolean isPigeonholeValid(Level level, BlockPos entityPos) {
        @Nullable BlockPos currentPos = this.getTargetPos();
        if (currentPos == null) {
            return false;
        }
        if (!entityPos.closerThan((Vec3i)currentPos, 32.0)) {
            return false;
        }
        return level.getBlockEntity(currentPos) instanceof PigeonholeBlockEntity;
    }

    public boolean isTargetBlacklisted(BlockPos pos) {
        return this.blacklistedPositions.contains(pos);
    }

    private void blacklistTarget(BlockPos pos) {
        this.blacklistedPositions.add(pos);
        while (this.blacklistedPositions.size() > 3) {
            this.blacklistedPositions.removeFirst();
        }
    }

    public void clearBlacklist() {
        this.blacklistedPositions.clear();
    }

    public void dropAndBlacklistPigeonhole() {
        if (this.getTargetPos() != null) {
            this.blacklistTarget(this.getTargetPos());
        }
        this.dropPigeonhole();
    }

    public void dropPigeonhole() {
        this.setTargetPos(null);
        this.resetLocateCooldown();
    }

    public String toString() {
        return "PigeonholeHandler{currentPos=" + String.valueOf(this.targetPos) + ", lastReleasePos=" + String.valueOf(this.lastReleasePos) + ", locateCooldown=" + this.locateCooldown + ", wantCooldown=" + this.wantCooldown + ", enterCooldown=" + this.enterCooldown + "}";
    }
}

