/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.entity.ai.goal;

import io.github.mortuusars.envelope.world.Position;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGoToBlockGoal
extends Goal {
    public static final int MAX_TRAVELLING_TICKS = 600;
    public static final int TICKS_BEFORE_DROP = 60;
    protected final Pigeon pigeon;
    protected int travellingTicks;
    protected int ticksStuck;

    public AbstractGoToBlockGoal(Pigeon pigeon) {
        this.pigeon = pigeon;
        this.travellingTicks = pigeon.level().random.nextInt(10);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    @Nullable
    public abstract BlockPos getBlockPos();

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean canUse() {
        @Nullable BlockPos pos = this.getBlockPos();
        return pos != null && !this.pigeon.hasRestriction() && !this.pigeon.hasReachedTarget(pos) && !Position.isFireNearby(this.pigeon.level(), pos);
    }

    public void start() {
        this.travellingTicks = 0;
        this.ticksStuck = 0;
        super.start();
    }

    public void stop() {
        this.travellingTicks = 0;
        this.ticksStuck = 0;
        this.pigeon.getNavigation().stop();
        this.pigeon.getNavigation().resetMaxVisitedNodesMultiplier();
    }
}

