/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.entity.ai.goal;

import io.github.mortuusars.envelope.world.block.mailbox.MailboxBlock;
import io.github.mortuusars.envelope.world.delivery.Delivery;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PigeonDeliverMailGoal
extends Goal {
    protected final Pigeon pigeon;

    public PigeonDeliverMailGoal(Pigeon pigeon) {
        this.pigeon = pigeon;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public Pigeon pigeon() {
        return this.pigeon;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean canUse() {
        return this.pigeon.isDelivering();
    }

    public void stop() {
        this.pigeon.setDelivery(null);
        this.pigeon.getNavigation().stop();
        this.pigeon.getNavigation().resetMaxVisitedNodesMultiplier();
    }

    public void tick() {
        Level level = this.pigeon.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        this.pigeon.getCurrentDelivery().ifPresent(delivery -> {
            this.pigeon().getDeliveryHandler().tickDelivery(level2, (Delivery)delivery);
            delivery.getRoute().getSegment(delivery.getPhase()).endPos().ifPresentOrElse(pos -> {
                BlockState state;
                if (delivery.getPhase().isDescending() && (state = level2.getBlockState(pos)).getBlock() instanceof MailboxBlock) {
                    pos.relative((Direction)state.getValue((Property)MailboxBlock.FACING));
                }
                if ((delivery.getPhase().isAscending() || delivery.getPhase().isDescending()) && this.pigeon.hasReachedTarget((BlockPos)pos)) {
                    delivery.setPhaseProgress(this.pigeon().getDeliveryHandler().getPhaseDuration(level2, (Delivery)delivery, delivery.getPhase()));
                    return;
                }
                if (!this.pigeon.getNavigation().isInProgress() || !pos.equals((Object)this.pigeon.getNavigation().getTargetPos())) {
                    this.pigeon.pathfindDirectlyTowards((BlockPos)pos);
                }
            }, () -> {
                @Nullable Vec3 randomPos = AirAndWaterRandomPos.getPos((PathfinderMob)this.pigeon, (int)8, (int)4, (int)-2, (double)this.pigeon.getX(), (double)this.pigeon.getZ(), (double)1.5707963705062866);
                if (randomPos != null && level2.getRandom().nextFloat() < 0.1f) {
                    this.pigeon.pathfindDirectlyTowards(BlockPos.containing((Position)randomPos));
                }
            });
        });
    }
}

